var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};
import React, { Component } from 'react';
import PropTypes from 'prop-types';
import classNames from 'classnames';
import { Modal, Button } from '@patternfly/react-core';
import './wizard.css';
var Wizard = (function (_super) {
    __extends(Wizard, _super);
    function Wizard() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.state = {
            currentStep: 0,
        };
        _this.handleNextModalStep = function () {
            _this.setState(function (_a) {
                var currentStep = _a.currentStep;
                return ({
                    currentStep: currentStep + 1,
                });
            });
        };
        _this.handlePreviousModalStep = function () {
            _this.setState(function (_a) {
                var currentStep = _a.currentStep;
                return ({
                    currentStep: currentStep - 1,
                });
            });
        };
        _this.handleOnClose = function (submit) {
            var result = _this.props.onClose(submit);
            if (result === false) {
                return;
            }
            _this.setState({ currentStep: 0 });
        };
        _this.handleKeyPress = function (event) {
            if (event.key === 'Enter' && _this.props.isValidated === true) {
                _this.handleNextModalStep();
            }
        };
        return _this;
    }
    Wizard.prototype.render = function () {
        var _this = this;
        var _a = this.props, isLarge = _a.isLarge, title = _a.title, className = _a.className, isOpen = _a.isOpen, isValidated = _a.isValidated, confirmAction = _a.confirmAction, props = __rest(_a, ["isLarge", "title", "className", "isOpen", "isValidated", "confirmAction"]);
        var wizardClasses = classNames('ins-c-wizard', className);
        var renderModalActions = [
            this.state.currentStep < this.props.content.length - 1 ? (React.createElement(Button, { key: "Next", action: "next", variant: "primary", isDisabled: !isValidated, onClick: this.handleNextModalStep }, "Next")) : (React.createElement(Button, { key: "confirm", action: "confirm", variant: "primary", isDisabled: !isValidated, onClick: function () { return _this.handleOnClose(true); } }, confirmAction)),
            this.state.currentStep !== 0 && (React.createElement(Button, { key: "back", action: "back", variant: "secondary", onClick: this.handlePreviousModalStep },
                ' ',
                "Back",
                ' ')),
            React.createElement(Button, { key: "cancel", action: "cancel", variant: "secondary", onClick: function () { return _this.handleOnClose(false); } }, "Cancel"),
        ];
        return (React.createElement(Modal, __assign({}, props, { onKeyPress: this.handleKeyPress, variant: "large", title: title, className: wizardClasses, isOpen: isOpen, onClose: function () { return _this.handleOnClose(false); }, actions: renderModalActions }), this.props.content[this.state.currentStep]));
    };
    return Wizard;
}(Component));
Wizard.propTypes = {
    isValidated: PropTypes.bool,
    isLarge: PropTypes.bool,
    title: PropTypes.string,
    className: PropTypes.string,
    confirmAction: PropTypes.string,
    isOpen: PropTypes.any,
    content: PropTypes.array,
    onClose: PropTypes.func,
};
Wizard.defaultProps = {
    onClose: function (f) { return f; },
    isValidated: true,
    confirmAction: 'Confirm',
};
export default Wizard;
//# sourceMappingURL=Wizard.js.map