"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.usePermissions = usePermissions;
exports["default"] = void 0;

var _regenerator = _interopRequireDefault(require("@babel/runtime/regenerator"));

var _asyncToGenerator2 = _interopRequireDefault(require("@babel/runtime/helpers/asyncToGenerator"));

var _slicedToArray2 = _interopRequireDefault(require("@babel/runtime/helpers/slicedToArray"));

var _react = require("react");

var _RBAC = require("../RBAC");

function usePermissions(appName, permissionsList) {
  var _useState = (0, _react.useState)({
    isLoading: true
  }),
      _useState2 = (0, _slicedToArray2["default"])(_useState, 2),
      permissions = _useState2[0],
      setPermissions = _useState2[1];

  (0, _react.useEffect)(function () {
    setPermissions({
      isLoading: true
    });
    (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee() {
      var _yield$getRBAC, isOrgAdmin, userPermissions;

      return _regenerator["default"].wrap(function _callee$(_context) {
        while (1) {
          switch (_context.prev = _context.next) {
            case 0:
              _context.next = 2;
              return (0, _RBAC.getRBAC)(appName);

            case 2:
              _yield$getRBAC = _context.sent;
              isOrgAdmin = _yield$getRBAC.isOrgAdmin;
              userPermissions = _yield$getRBAC.permissions;
              setPermissions({
                isLoading: false,
                isOrgAdmin: isOrgAdmin,
                permissions: userPermissions,
                hasAccess: (0, _RBAC.doesHavePermissions)(userPermissions, permissionsList)
              });

            case 6:
            case "end":
              return _context.stop();
          }
        }
      }, _callee);
    }))();
  }, [appName]);
  return permissions;
}

var _default = usePermissions;
exports["default"] = _default;