import { Cluster, ClusterValidationId, Host, HostValidationId } from '../../../common';
import { ValidationGroup as ClusterValidationGroup, ValidationsInfo as ClusterValidationsInfo } from '../../../common/types/clusters';
import { ValidationGroup as HostValidationGroup, ValidationsInfo as HostValidationsInfo, ValidationsInfo } from '../../../common/types/hosts';
export declare type ClusterWizardStepsType = 'cluster-details' | 'host-discovery' | 'networking' | 'review';
export declare type ClusterWizardFlowStateType = Cluster['status'] | 'new';
export declare const getClusterWizardFirstStep: (state?: "error" | "insufficient" | "preparing-for-installation" | "pending-for-input" | "installing" | "installing-pending-user-action" | "installed" | "cancelled" | "ready" | "finalizing" | "adding-hosts" | "new" | undefined) => ClusterWizardStepsType;
declare type TransitionProps = {
    cluster: Cluster;
};
declare type WizardStepValidationMap = {
    cluster: {
        groups: ClusterValidationGroup[];
        validationIds: ClusterValidationId[];
    };
    host: {
        allowedStatuses: Host['status'][];
        groups: HostValidationGroup[];
        validationIds: HostValidationId[];
    };
    softValidationIds: (HostValidationId | ClusterValidationId)[];
};
declare type WizardStepsValidationMap = {
    [key in ClusterWizardStepsType]: WizardStepValidationMap;
};
export declare const wizardStepsValidationsMap: WizardStepsValidationMap;
export declare const allClusterWizardSoftValidationIds: WizardStepValidationMap['softValidationIds'];
export declare const getFailingClusterWizardSoftValidationIds: (wizardHostStepValidationsInfo: ValidationsInfo, wizardStepId: ClusterWizardStepsType) => HostValidationId[];
export declare const checkClusterValidations: (clusterValidationsInfo: ClusterValidationsInfo, requiredIds: ClusterValidationId[]) => boolean;
export declare const checkClusterValidationGroups: (clusterValidationsInfo: ClusterValidationsInfo, groups: ClusterValidationGroup[], softValidationIds: WizardStepValidationMap['softValidationIds']) => boolean;
export declare const checkHostValidations: (hostValidationsInfo: HostValidationsInfo, requiredIds: HostValidationId[]) => boolean;
export declare const checkHostValidationGroups: (hostValidationsInfo: HostValidationsInfo, groups: HostValidationGroup[], softValidationIds: WizardStepValidationMap['softValidationIds']) => boolean;
export declare const getWizardStepHostValidationsInfo: (validationsInfo: HostValidationsInfo, wizardStepId: ClusterWizardStepsType) => HostValidationsInfo;
export declare const getWizardStepHostStatus: (host: Host, wizardStepId: ClusterWizardStepsType) => Host['status'];
export declare const getWizardStepClusterValidationsInfo: (validationsInfo: ClusterValidationsInfo, wizardStepId: ClusterWizardStepsType) => ClusterValidationsInfo;
export declare const getWizardStepClusterStatus: (cluster: Cluster, wizardStepId: ClusterWizardStepsType) => Cluster['status'];
export declare const findValidationFixStep: ({ id, hostGroup, clusterGroup, }: {
    id: ClusterValidationId | HostValidationId;
    hostGroup?: "hardware" | "network" | "operators" | "infrastructure" | undefined;
    clusterGroup?: "network" | "operators" | "configuration" | "hostsData" | undefined;
}) => ClusterWizardStepsType | undefined;
export declare const canNextClusterDetails: ({ cluster }: TransitionProps) => boolean;
export declare const canNextHostDiscovery: ({ cluster }: TransitionProps) => boolean;
export declare const canNextNetwork: ({ cluster }: TransitionProps) => boolean;
export {};
