var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};
import React from 'react';
import { Title, Button, EmptyState, EmptyStateVariant, EmptyStateIcon, EmptyStateBody } from '@patternfly/react-core';
import { LockIcon } from '@patternfly/react-icons';
import './NotAuthorized.css';
var ContactBody = function () { return (React.createElement(React.Fragment, null,
    "Contact your organization administrator(s) for more information or visit\u00A0",
    React.createElement("a", { href: "./settings/my-user-access" }, "My User Access"),
    "\u00A0 to learn more about your permissions.")); };
var NotAuthorized = function (_a) {
    var _b = _a.prevPageButtonText, prevPageButtonText = _b === void 0 ? 'Return to previous page' : _b, _c = _a.toLandingPageText, toLandingPageText = _c === void 0 ? 'Go to landing page' : _c, title = _a.title, _d = _a.actions, actions = _d === void 0 ? null : _d, serviceName = _a.serviceName, _e = _a.icon, Icon = _e === void 0 ? LockIcon : _e, _f = _a.description, description = _f === void 0 ? React.createElement(ContactBody, null) : _f, _g = _a.showReturnButton, showReturnButton = _g === void 0 ? true : _g, className = _a.className, props = __rest(_a, ["prevPageButtonText", "toLandingPageText", "title", "actions", "serviceName", "icon", "description", "showReturnButton", "className"]);
    var heading = title || "You do not have access to ".concat(serviceName);
    return (React.createElement(EmptyState, __assign({ variant: EmptyStateVariant.full, className: "ins-c-not-authorized ".concat(className || '') }, props),
        React.createElement(EmptyStateIcon, { icon: Icon }),
        React.createElement(Title, { headingLevel: "h5", size: "lg" }, heading),
        React.createElement(EmptyStateBody, null, description),
        actions,
        showReturnButton &&
            (document.referrer ? (React.createElement(Button, { variant: "primary", onClick: function () { return history.back(); } }, prevPageButtonText)) : (React.createElement(Button, { variant: "primary", component: "a", href: "." }, toLandingPageText)))));
};
export default NotAuthorized;
//# sourceMappingURL=NotAuthorized.js.map