+++
# -----------------------------------------------------------------------
# Do not edit this file. It is automatically generated by API Documenter.
# -----------------------------------------------------------------------
title = "PanelPlugin"
keywords = ["grafana","documentation","sdk","@grafana/data"]
type = "docs"
draft = true
+++

## PanelPlugin class

<b>Signature</b>

```typescript
export declare class PanelPlugin<TOptions = any> extends GrafanaPlugin<PanelPluginMeta> 
```
<b>Import</b>

```typescript
import { PanelPlugin } from '@grafana/data';
```
<b>Constructors</b>

|  Constructor | Modifiers | Description |
|  --- | --- | --- |
|  [constructor(panel)](#constructor-panel) |  | Constructs a new instance of the <code>PanelPlugin</code> class |

<b>Properties</b>

|  Property | Modifiers | Type | Description |
|  --- | --- | --- | --- |
|  [angularPanelCtrl](#angularpanelctrl-property) |  | <code>any</code> | Legacy angular ctrl. If this exists it will be used instead of the panel |
|  [customFieldConfigs](#customfieldconfigs-property) |  | <code>FieldConfigEditorRegistry</code> |  |
|  [defaults](#defaults-property) |  | <code>TOptions</code> |  |
|  [editor](#editor-property) |  | <code>ComponentClass&lt;PanelEditorProps&lt;TOptions&gt;&gt;</code> |  |
|  [noPadding](#nopadding-property) |  | <code>boolean</code> |  |
|  [onPanelMigration](#onpanelmigration-property) |  | <code>PanelMigrationHandler&lt;TOptions&gt;</code> |  |
|  [onPanelTypeChanged](#onpaneltypechanged-property) |  | <code>PanelTypeChangedHandler&lt;TOptions&gt;</code> |  |
|  [panel](#panel-property) |  | <code>ComponentType&lt;PanelProps&lt;TOptions&gt;&gt;</code> |  |

<b>Methods</b>

|  Method | Modifiers | Description |
|  --- | --- | --- |
|  [setCustomFieldConfigs(registry)](#setcustomfieldconfigs-method) |  |  |
|  [setDefaults(defaults)](#setdefaults-method) |  |  |
|  [setEditor(editor)](#seteditor-method) |  |  |
|  [setMigrationHandler(handler)](#setmigrationhandler-method) |  | This function is called before the panel first loads if the current version is different than the version that was saved.<!-- -->This is a good place to support any changes to the options model |
|  [setNoPadding()](#setnopadding-method) |  |  |
|  [setPanelChangeHandler(handler)](#setpanelchangehandler-method) |  | This function is called when the visualization was changed. This passes in the options that were used in the previous visualization |

### constructor(panel)

Constructs a new instance of the `PanelPlugin` class

<b>Signature</b>

```typescript
constructor(panel: ComponentType<PanelProps<TOptions>>);
```
<b>Parameters</b>

|  Parameter | Type | Description |
|  --- | --- | --- |
|  panel | <code>ComponentType&lt;PanelProps&lt;TOptions&gt;&gt;</code> |  |

### angularPanelCtrl property

Legacy angular ctrl. If this exists it will be used instead of the panel

<b>Signature</b>

```typescript
angularPanelCtrl?: any;
```

### customFieldConfigs property

<b>Signature</b>

```typescript
customFieldConfigs?: FieldConfigEditorRegistry;
```

### defaults property

<b>Signature</b>

```typescript
defaults?: TOptions;
```

### editor property

<b>Signature</b>

```typescript
editor?: ComponentClass<PanelEditorProps<TOptions>>;
```

### noPadding property

<b>Signature</b>

```typescript
noPadding?: boolean;
```

### onPanelMigration property

<b>Signature</b>

```typescript
onPanelMigration?: PanelMigrationHandler<TOptions>;
```

### onPanelTypeChanged property

<b>Signature</b>

```typescript
onPanelTypeChanged?: PanelTypeChangedHandler<TOptions>;
```

### panel property

<b>Signature</b>

```typescript
panel: ComponentType<PanelProps<TOptions>>;
```

### setCustomFieldConfigs method

<b>Signature</b>

```typescript
setCustomFieldConfigs(registry: FieldConfigEditorRegistry): this;
```
<b>Parameters</b>

|  Parameter | Type | Description |
|  --- | --- | --- |
|  registry | <code>FieldConfigEditorRegistry</code> |  |

<b>Returns:</b>

`this`

### setDefaults method

<b>Signature</b>

```typescript
setDefaults(defaults: TOptions): this;
```
<b>Parameters</b>

|  Parameter | Type | Description |
|  --- | --- | --- |
|  defaults | <code>TOptions</code> |  |

<b>Returns:</b>

`this`

### setEditor method

<b>Signature</b>

```typescript
setEditor(editor: ComponentClass<PanelEditorProps<TOptions>>): this;
```
<b>Parameters</b>

|  Parameter | Type | Description |
|  --- | --- | --- |
|  editor | <code>ComponentClass&lt;PanelEditorProps&lt;TOptions&gt;&gt;</code> |  |

<b>Returns:</b>

`this`

### setMigrationHandler method

This function is called before the panel first loads if the current version is different than the version that was saved.

This is a good place to support any changes to the options model

<b>Signature</b>

```typescript
setMigrationHandler(handler: PanelMigrationHandler): this;
```
<b>Parameters</b>

|  Parameter | Type | Description |
|  --- | --- | --- |
|  handler | <code>PanelMigrationHandler</code> |  |

<b>Returns:</b>

`this`

### setNoPadding method

<b>Signature</b>

```typescript
setNoPadding(): this;
```
<b>Returns:</b>

`this`

### setPanelChangeHandler method

This function is called when the visualization was changed. This passes in the options that were used in the previous visualization

<b>Signature</b>

```typescript
setPanelChangeHandler(handler: PanelTypeChangedHandler): this;
```
<b>Parameters</b>

|  Parameter | Type | Description |
|  --- | --- | --- |
|  handler | <code>PanelTypeChangedHandler</code> |  |

<b>Returns:</b>

`this`

