---
title: Box shadow
section: utilities
---

import './BoxShadow.css'

## Examples
```hbs title=Small
{{#> box-shadow box-shadow--modifier="pf-u-box-shadow-sm"}}
  Regular
{{/box-shadow}}
{{#> box-shadow box-shadow--modifier="pf-u-box-shadow-sm-top"}}
  Top
{{/box-shadow}}
{{#> box-shadow box-shadow--modifier="pf-u-box-shadow-sm-right"}}
  Right
{{/box-shadow}}
{{#> box-shadow box-shadow--modifier="pf-u-box-shadow-sm-bottom"}}
  Bottom
{{/box-shadow}}
{{#> box-shadow box-shadow--modifier="pf-u-box-shadow-sm-left"}}
  Left
{{/box-shadow}}
```

```hbs title=Medium
{{#> box-shadow box-shadow--modifier="pf-u-box-shadow-md"}}
  Regular
{{/box-shadow}}
{{#> box-shadow box-shadow--modifier="pf-u-box-shadow-md-top"}}
  Top
{{/box-shadow}}
{{#> box-shadow box-shadow--modifier="pf-u-box-shadow-md-right"}}
  Right
{{/box-shadow}}
{{#> box-shadow box-shadow--modifier="pf-u-box-shadow-md-bottom"}}
  Bottom
{{/box-shadow}}
{{#> box-shadow box-shadow--modifier="pf-u-box-shadow-md-left"}}
  Left
{{/box-shadow}}
```

```hbs title=Large
{{#> box-shadow box-shadow--modifier="pf-u-box-shadow-lg"}}
  Regular
{{/box-shadow}}
{{#> box-shadow box-shadow--modifier="pf-u-box-shadow-lg-top"}}
  Top
{{/box-shadow}}
{{#> box-shadow box-shadow--modifier="pf-u-box-shadow-lg-right"}}
  Right
{{/box-shadow}}
{{#> box-shadow box-shadow--modifier="pf-u-box-shadow-lg-bottom"}}
  Bottom
{{/box-shadow}}
{{#> box-shadow box-shadow--modifier="pf-u-box-shadow-lg-left"}}
  Left
{{/box-shadow}}
```

```hbs title=Extra-large
{{#> box-shadow box-shadow--modifier="pf-u-box-shadow-xl"}}
  Regular
{{/box-shadow}}
{{#> box-shadow box-shadow--modifier="pf-u-box-shadow-xl-top"}}
  Top
{{/box-shadow}}
{{#> box-shadow box-shadow--modifier="pf-u-box-shadow-xl-right"}}
  Right
{{/box-shadow}}
{{#> box-shadow box-shadow--modifier="pf-u-box-shadow-xl-bottom"}}
  Bottom
{{/box-shadow}}
{{#> box-shadow box-shadow--modifier="pf-u-box-shadow-xl-left"}}
  Left
{{/box-shadow}}
```

```hbs title=Inset
{{#> box-shadow box-shadow--modifier="pf-u-box-shadow-inset"}}
  Regular
{{/box-shadow}}
```

## Documentation
### Overview
Box shadow utility

### Usage
| Class | Applied to | Outcome |
| -- | -- | -- |
| `.pf-u-box-shadow-sm` | `*` |  Applies box-shadow small. |
| `.pf-u-box-shadow-sm-top` | `*` |  Applies box-shadow small top. |
| `.pf-u-box-shadow-sm-right` | `*` |  Applies box-shadow small right. |
| `.pf-u-box-shadow-sm-bottom` | `*` |  Applies box-shadow small bottom. |
| `.pf-u-box-shadow-sm-left` | `*` |  Applies box-shadow small left. |
| `.pf-u-box-shadow-md` | `*` |  Applies box-shadow medium. |
| `.pf-u-box-shadow-md-top` | `*` |  Applies box-shadow medium top. |
| `.pf-u-box-shadow-md-right` | `*` |  Applies box-shadow medium right. |
| `.pf-u-box-shadow-md-bottom` | `*` |  Applies box-shadow medium bottom. |
| `.pf-u-box-shadow-md-left` | `*` |  Applies box-shadow medium left. |
| `.pf-u-box-shadow-lg` | `*` |  Applies box-shadow large. |
| `.pf-u-box-shadow-lg-top` | `*` |  Applies box-shadow large top. |
| `.pf-u-box-shadow-lg-right` | `*` |  Applies box-shadow large right. |
| `.pf-u-box-shadow-lg-bottom` | `*` |  Applies box-shadow large bottom. |
| `.pf-u-box-shadow-lg-left` | `*` |  Applies box-shadow large left. |
| `.pf-u-box-shadow-xl` | `*` |  Applies box-shadow x-large. |
| `.pf-u-box-shadow-xl-top` | `*` |  Applies box-shadow x-large top. |
| `.pf-u-box-shadow-xl-right` | `*` |  Applies box-shadow x-large right. |
| `.pf-u-box-shadow-xl-bottom` | `*` |  Applies box-shadow x-large bottom. |
| `.pf-u-box-shadow-xl-left` | `*` |  Applies box-shadow x-large left. |
