"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const tslib_1 = require("tslib");
/**
 * header-row.tsx
 *
 * Forked from reactabular-table version 8.14.0
 * https://github.com/reactabular/reactabular/tree/v8.14.0/packages/reactabular-table/src
 */
const React = tslib_1.__importStar(require("react"));
const evaluate_formatters_1 = require("./evaluate-formatters");
const evaluate_transforms_1 = require("./evaluate-transforms");
const merge_props_1 = require("./merge-props");
exports.HeaderRow = ({ rowData, rowIndex, renderers, onRow = () => Object }) => React.createElement(renderers.row, onRow(rowData, { rowIndex }), rowData.map((column, columnIndex) => {
    const { property, header = {}, props = {} } = column;
    const evaluatedProperty = property || (header && header.property);
    const { label, transforms = [], formatters = [] } = header;
    const extraParameters = {
        columnIndex,
        property: evaluatedProperty,
        column
    };
    const transformedProps = evaluate_transforms_1.evaluateTransforms(transforms, label, extraParameters);
    if (!transformedProps) {
        // tslint:disable-next-line:no-console
        console.warn('Table.Header - Failed to receive a transformed result'); // eslint-disable-line max-len, no-console
    }
    return React.createElement(renderers.cell, Object.assign({ key: `${columnIndex}-header` }, merge_props_1.mergeProps(props, header && header.props, transformedProps)), transformedProps.children || evaluate_formatters_1.evaluateFormatters(formatters)(label, extraParameters));
}));
//# sourceMappingURL=header-row.js.map