/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.publish.ivy.plugins;

import java.util.Set;
import javax.inject.Inject;
import org.apache.commons.lang.StringUtils;
import org.gradle.api.NamedDomainObjectFactory;
import org.gradle.api.NamedDomainObjectList;
import org.gradle.api.NamedDomainObjectSet;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.repositories.IvyArtifactRepository;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.internal.artifacts.Module;
import org.gradle.api.internal.artifacts.configurations.DependencyMetaDataProvider;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.plugins.ExtensionContainer;
import org.gradle.api.plugins.PluginManager;
import org.gradle.api.publish.PublishingExtension;
import org.gradle.api.publish.internal.versionmapping.VersionMappingStrategyInternal;
import org.gradle.api.publish.ivy.IvyArtifact;
import org.gradle.api.publish.ivy.IvyPublication;
import org.gradle.api.publish.ivy.internal.artifact.IvyArtifactNotationParserFactory;
import org.gradle.api.publish.ivy.internal.publication.DefaultIvyPublication;
import org.gradle.api.publish.ivy.internal.publication.DefaultIvyPublicationIdentity;
import org.gradle.api.publish.ivy.internal.publication.IvyPublicationInternal;
import org.gradle.api.publish.ivy.internal.versionmapping.DefaultVersionMappingStrategy;
import org.gradle.api.publish.ivy.tasks.GenerateIvyDescriptor;
import org.gradle.api.publish.ivy.tasks.PublishToIvyRepository;
import org.gradle.api.publish.plugins.PublishingPlugin;
import org.gradle.api.publish.tasks.GenerateModuleMetadata;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.SourceSetContainer;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.internal.typeconversion.NotationParser;
import org.gradle.model.Path;

public class IvyPublishPlugin
implements Plugin<Project> {
    private final Instantiator instantiator;
    private final ObjectFactory objectFactory;
    private final DependencyMetaDataProvider dependencyMetaDataProvider;
    private final FileResolver fileResolver;

    @Inject
    public IvyPublishPlugin(Instantiator instantiator, ObjectFactory objectFactory, DependencyMetaDataProvider dependencyMetaDataProvider, FileResolver fileResolver) {
        this.instantiator = instantiator;
        this.objectFactory = objectFactory;
        this.dependencyMetaDataProvider = dependencyMetaDataProvider;
        this.fileResolver = fileResolver;
    }

    public void apply(Project project) {
        project.getPluginManager().apply(PublishingPlugin.class);
        project.getExtensions().configure(PublishingExtension.class, extension -> {
            extension.getPublications().registerFactory(IvyPublication.class, (NamedDomainObjectFactory)new IvyPublicationFactory(this.dependencyMetaDataProvider, this.instantiator, this.objectFactory, this.fileResolver, project.getPluginManager(), project.getExtensions()));
            this.createTasksLater(project, (PublishingExtension)extension, project.getLayout().getBuildDirectory());
        });
    }

    private void createTasksLater(Project project, PublishingExtension publishingExtension, DirectoryProperty buildDir) {
        TaskContainer tasks = project.getTasks();
        NamedDomainObjectSet publications = publishingExtension.getPublications().withType(IvyPublicationInternal.class);
        NamedDomainObjectList repositories = publishingExtension.getRepositories().withType(IvyArtifactRepository.class);
        repositories.all(repository -> tasks.register(this.publishAllToSingleRepoTaskName((IvyArtifactRepository)repository), publish -> {
            publish.setDescription("Publishes all Maven publications produced by this project to the " + repository.getName() + " repository.");
            publish.setGroup("publishing");
        }));
        publications.all(publication -> {
            String publicationName = publication.getName();
            this.createGenerateIvyDescriptorTask(tasks, publicationName, (IvyPublicationInternal)publication, buildDir);
            this.createGenerateMetadataTask(tasks, (IvyPublicationInternal)publication, (Set<IvyPublicationInternal>)publications, buildDir);
            this.createPublishTaskForEachRepository(tasks, (IvyPublicationInternal)publication, publicationName, (NamedDomainObjectList<IvyArtifactRepository>)repositories);
        });
    }

    private String publishAllToSingleRepoTaskName(IvyArtifactRepository repository) {
        return "publishAllPublicationsTo" + StringUtils.capitalize((String)repository.getName()) + "Repository";
    }

    private void createPublishTaskForEachRepository(TaskContainer tasks, IvyPublicationInternal publication, String publicationName, NamedDomainObjectList<IvyArtifactRepository> repositories) {
        repositories.all(repository -> {
            String repositoryName = repository.getName();
            String publishTaskName = "publish" + StringUtils.capitalize((String)publicationName) + "PublicationTo" + StringUtils.capitalize((String)repositoryName) + "Repository";
            this.createPublishToRepositoryTask(tasks, publication, publicationName, (IvyArtifactRepository)repository, repositoryName, publishTaskName);
        });
    }

    private void createPublishToRepositoryTask(TaskContainer tasks, IvyPublicationInternal publication, String publicationName, IvyArtifactRepository repository, String repositoryName, String publishTaskName) {
        tasks.register(publishTaskName, PublishToIvyRepository.class, publishTask -> {
            publishTask.setPublication(publication);
            publishTask.setRepository(repository);
            publishTask.setGroup("publishing");
            publishTask.setDescription("Publishes Ivy publication '" + publicationName + "' to Ivy repository '" + repositoryName + "'.");
        });
        tasks.named("publish", task -> task.dependsOn(new Object[]{publishTaskName}));
        tasks.named(this.publishAllToSingleRepoTaskName(repository), publish -> publish.dependsOn(new Object[]{publishTaskName}));
    }

    private void createGenerateIvyDescriptorTask(TaskContainer tasks, String publicationName, IvyPublicationInternal publication, @Path(value="buildDir") DirectoryProperty buildDir) {
        String descriptorTaskName = "generateDescriptorFileFor" + StringUtils.capitalize((String)publicationName) + "Publication";
        TaskProvider generatorTask = tasks.register(descriptorTaskName, GenerateIvyDescriptor.class, descriptorTask -> {
            descriptorTask.setDescription("Generates the Ivy Module Descriptor XML file for publication '" + publicationName + "'.");
            descriptorTask.setGroup("publishing");
            descriptorTask.setDescriptor(publication.getDescriptor());
            if (descriptorTask.getDestination() == null) {
                descriptorTask.setDestination(buildDir.file("publications/" + publicationName + "/ivy.xml"));
            }
        });
        publication.setIvyDescriptorGenerator((TaskProvider<? extends Task>)generatorTask);
    }

    private void createGenerateMetadataTask(TaskContainer tasks, IvyPublicationInternal publication, Set<IvyPublicationInternal> publications, DirectoryProperty buildDir) {
        String publicationName = publication.getName();
        String descriptorTaskName = "generateMetadataFileFor" + StringUtils.capitalize((String)publicationName) + "Publication";
        TaskProvider generatorTask = tasks.register(descriptorTaskName, GenerateModuleMetadata.class, generateTask -> {
            generateTask.setDescription("Generates the Gradle metadata file for publication '" + publicationName + "'.");
            generateTask.setGroup("publishing");
            generateTask.getPublication().set((Object)publication);
            generateTask.getPublications().set((Iterable)publications);
            generateTask.getOutputFile().convention(buildDir.file("publications/" + publicationName + "/module.json"));
        });
        publication.setModuleDescriptorGenerator((TaskProvider<? extends Task>)generatorTask);
    }

    private static class IvyPublicationFactory
    implements NamedDomainObjectFactory<IvyPublication> {
        private final Instantiator instantiator;
        private final DependencyMetaDataProvider dependencyMetaDataProvider;
        private final ObjectFactory objectFactory;
        private final FileResolver fileResolver;
        private final PluginManager plugins;
        private final ExtensionContainer extensionContainer;

        private IvyPublicationFactory(DependencyMetaDataProvider dependencyMetaDataProvider, Instantiator instantiator, ObjectFactory objectFactory, FileResolver fileResolver, PluginManager plugins, ExtensionContainer extensionContainer) {
            this.dependencyMetaDataProvider = dependencyMetaDataProvider;
            this.instantiator = instantiator;
            this.objectFactory = objectFactory;
            this.fileResolver = fileResolver;
            this.plugins = plugins;
            this.extensionContainer = extensionContainer;
        }

        public IvyPublication create(String name) {
            Module module = this.dependencyMetaDataProvider.getModule();
            DefaultIvyPublicationIdentity publicationIdentity = new DefaultIvyPublicationIdentity(module);
            NotationParser<Object, IvyArtifact> notationParser = new IvyArtifactNotationParserFactory(this.instantiator, this.fileResolver, publicationIdentity).create();
            VersionMappingStrategyInternal versionMappingStrategy = (VersionMappingStrategyInternal)this.objectFactory.newInstance(DefaultVersionMappingStrategy.class, new Object[0]);
            this.configureDefaultConfigurationsUsedWhenMappingToResolvedVersions(versionMappingStrategy);
            return (IvyPublication)this.objectFactory.newInstance(DefaultIvyPublication.class, new Object[]{name, publicationIdentity, notationParser, versionMappingStrategy});
        }

        private void configureDefaultConfigurationsUsedWhenMappingToResolvedVersions(VersionMappingStrategyInternal versionMappingStrategy) {
            this.plugins.withPlugin("org.gradle.java", plugin -> {
                SourceSet mainSourceSet = (SourceSet)((SourceSetContainer)this.extensionContainer.getByType(SourceSetContainer.class)).getByName("main");
                versionMappingStrategy.defaultResolutionConfiguration("java-api", mainSourceSet.getCompileClasspathConfigurationName());
                versionMappingStrategy.defaultResolutionConfiguration("java-runtime", mainSourceSet.getRuntimeClasspathConfigurationName());
            });
            this.plugins.withPlugin("org.gradle.java-platform", plugin -> {
                versionMappingStrategy.defaultResolutionConfiguration("java-api", "classpath");
                versionMappingStrategy.defaultResolutionConfiguration("java-runtime", "classpath");
            });
        }
    }
}

