/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.file;

import java.io.File;
import javax.annotation.concurrent.ThreadSafe;
import org.gradle.internal.hash.FileHasher;
import org.gradle.internal.hash.HashCode;
import org.gradle.util.GFileUtils;

@ThreadSafe
public class JarCache {
    private final FileHasher fileHasher;

    public JarCache(FileHasher fileHasher) {
        this.fileHasher = fileHasher;
    }

    public File getCachedJar(File original, File cacheDir) {
        HashCode hashValue = this.fileHasher.hash(original);
        File cachedFile = new File(cacheDir, hashValue.toString() + '/' + original.getName());
        if (!cachedFile.isFile()) {
            GFileUtils.copyFile((File)original, (File)cachedFile);
        }
        return cachedFile;
    }
}

