/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.workers.internal;

import javax.annotation.concurrent.ThreadSafe;
import org.gradle.internal.operations.BuildOperationExecutor;
import org.gradle.internal.operations.BuildOperationRef;
import org.gradle.workers.IsolationMode;
import org.gradle.workers.internal.AbstractWorker;
import org.gradle.workers.internal.ActionExecutionSpec;
import org.gradle.workers.internal.BuildOperationAwareWorker;
import org.gradle.workers.internal.DaemonForkOptions;
import org.gradle.workers.internal.DefaultWorkResult;
import org.gradle.workers.internal.ForkedWorkerRequirement;
import org.gradle.workers.internal.WorkerDaemonClient;
import org.gradle.workers.internal.WorkerDaemonClientsManager;
import org.gradle.workers.internal.WorkerDaemonServer;
import org.gradle.workers.internal.WorkerFactory;
import org.gradle.workers.internal.WorkerRequirement;

@ThreadSafe
public class WorkerDaemonFactory
implements WorkerFactory {
    private final WorkerDaemonClientsManager clientsManager;
    private final BuildOperationExecutor buildOperationExecutor;

    public WorkerDaemonFactory(WorkerDaemonClientsManager clientsManager, BuildOperationExecutor buildOperationExecutor) {
        this.clientsManager = clientsManager;
        this.buildOperationExecutor = buildOperationExecutor;
    }

    @Override
    public BuildOperationAwareWorker getWorker(final WorkerRequirement workerRequirement) {
        return new AbstractWorker(this.buildOperationExecutor){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public DefaultWorkResult execute(ActionExecutionSpec spec, BuildOperationRef parentBuildOperation) {
                WorkerDaemonClient client = this.reserveClient();
                try {
                    DefaultWorkResult defaultWorkResult = this.executeWrappedInBuildOperation(spec, parentBuildOperation, client::execute);
                    return defaultWorkResult;
                }
                finally {
                    WorkerDaemonFactory.this.clientsManager.release(client);
                }
            }

            private WorkerDaemonClient reserveClient() {
                DaemonForkOptions forkOptions = ((ForkedWorkerRequirement)workerRequirement).getForkOptions();
                WorkerDaemonClient client = WorkerDaemonFactory.this.clientsManager.reserveIdleClient(forkOptions);
                if (client == null) {
                    client = WorkerDaemonFactory.this.clientsManager.reserveNewClient(WorkerDaemonServer.class, forkOptions);
                }
                return client;
            }
        };
    }

    @Override
    public IsolationMode getIsolationMode() {
        return IsolationMode.PROCESS;
    }
}

