/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.config;

import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.config.AnalysisFlag;
import org.jetbrains.kotlin.config.ApiVersion;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.config.LanguageVersion;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.config.LanguageVersionSettingsImpl$WhenMappings;
import org.jetbrains.kotlin.config.LanguageVersionSettingsKt;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cBI\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u001a\b\u0002\u0010\u0006\u001a\u0014\u0012\b\u0012\u0006\u0012\u0002\b\u00030\b\u0012\u0006\u0012\u0004\u0018\u00010\t0\u0007\u0012\u0014\b\u0002\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\u0007\u00a2\u0006\u0002\u0010\rJ\u0010\u0010\u0012\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u000bH\u0016J!\u0010\u0014\u001a\u0002H\u0015\"\u0004\b\u0000\u0010\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u0002H\u00150\bH\u0016\u00a2\u0006\u0002\u0010\u0017J\b\u0010\u0018\u001a\u00020\u0019H\u0016J\b\u0010\u001a\u001a\u00020\u001bH\u0016R\u001c\u0010\u0006\u001a\u0010\u0012\b\u0012\u0006\u0012\u0002\b\u00030\b\u0012\u0002\b\u00030\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/kotlin/config/LanguageVersionSettingsImpl;", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "languageVersion", "Lorg/jetbrains/kotlin/config/LanguageVersion;", "apiVersion", "Lorg/jetbrains/kotlin/config/ApiVersion;", "analysisFlags", "", "Lorg/jetbrains/kotlin/config/AnalysisFlag;", "", "specificFeatures", "Lorg/jetbrains/kotlin/config/LanguageFeature;", "Lorg/jetbrains/kotlin/config/LanguageFeature$State;", "(Lorg/jetbrains/kotlin/config/LanguageVersion;Lorg/jetbrains/kotlin/config/ApiVersion;Ljava/util/Map;Ljava/util/Map;)V", "getApiVersion", "()Lorg/jetbrains/kotlin/config/ApiVersion;", "getLanguageVersion", "()Lorg/jetbrains/kotlin/config/LanguageVersion;", "getFeatureSupport", "feature", "getFlag", "T", "flag", "(Lorg/jetbrains/kotlin/config/AnalysisFlag;)Ljava/lang/Object;", "isPreRelease", "", "toString", "", "Companion", "util"})
public final class LanguageVersionSettingsImpl
implements LanguageVersionSettings {
    private final Map<AnalysisFlag<?>, ?> analysisFlags;
    private final Map<LanguageFeature, LanguageFeature.State> specificFeatures;
    @NotNull
    private final LanguageVersion languageVersion;
    @NotNull
    private final ApiVersion apiVersion;
    @JvmField
    @NotNull
    public static final LanguageVersionSettingsImpl DEFAULT;
    public static final Companion Companion;

    @Override
    public <T> T getFlag(@NotNull AnalysisFlag<? extends T> flag) {
        Intrinsics.checkParameterIsNotNull(flag, (String)"flag");
        Object object = this.analysisFlags.get(flag);
        if (object == null) {
            object = flag.getDefaultValue();
        }
        return (T)object;
    }

    @Override
    @NotNull
    public LanguageFeature.State getFeatureSupport(@NotNull LanguageFeature feature) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)feature), (String)"feature");
        LanguageFeature.State state = this.specificFeatures.get((Object)feature);
        if (state != null) {
            LanguageFeature.State state2 = state;
            boolean bl = false;
            boolean bl2 = false;
            LanguageFeature.State it = state2;
            boolean bl3 = false;
            return it;
        }
        LanguageVersion since = feature.getSinceVersion();
        if (since != null && this.getLanguageVersion().compareTo((Enum)since) >= 0 && this.getApiVersion().compareTo(feature.getSinceApiVersion()) >= 0) {
            return feature.getDefaultState();
        }
        return LanguageFeature.State.DISABLED;
    }

    @NotNull
    public String toString() {
        boolean bl = false;
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl2 = false;
        boolean bl3 = false;
        StringBuilder $this$buildString = stringBuilder;
        boolean bl4 = false;
        $this$buildString.append("Language = " + this.getLanguageVersion() + ", API = " + this.getApiVersion());
        Map<LanguageFeature, LanguageFeature.State> $this$forEach$iv = this.specificFeatures;
        boolean $i$f$forEach = false;
        Map<LanguageFeature, LanguageFeature.State> map2 = $this$forEach$iv;
        boolean bl5 = false;
        Iterator<Map.Entry<LanguageFeature, LanguageFeature.State>> iterator2 = map2.entrySet().iterator();
        while (iterator2.hasNext()) {
            char c;
            Map.Entry<LanguageFeature, LanguageFeature.State> element$iv;
            Map.Entry<LanguageFeature, LanguageFeature.State> $dstr$feature$state = element$iv = iterator2.next();
            boolean bl6 = false;
            Map.Entry<LanguageFeature, LanguageFeature.State> entry = $dstr$feature$state;
            boolean bl7 = false;
            LanguageFeature feature = entry.getKey();
            entry = $dstr$feature$state;
            bl7 = false;
            LanguageFeature.State state = entry.getValue();
            switch (LanguageVersionSettingsImpl$WhenMappings.$EnumSwitchMapping$0[state.ordinal()]) {
                case 1: {
                    c = '+';
                    break;
                }
                case 2: {
                    c = '~';
                    break;
                }
                case 3: 
                case 4: {
                    c = '-';
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            char c2 = c;
            $this$buildString.append("" + ' ' + c2 + (Object)((Object)feature));
        }
        String string2 = stringBuilder.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"StringBuilder().apply(builderAction).toString()");
        return string2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isPreRelease() {
        boolean bl;
        if (LanguageVersionSettingsKt.isPreRelease(this.getLanguageVersion())) return true;
        Map<LanguageFeature, LanguageFeature.State> $this$any$iv = this.specificFeatures;
        boolean $i$f$any = false;
        if ($this$any$iv.isEmpty()) {
            return false;
        }
        Map<LanguageFeature, LanguageFeature.State> map2 = $this$any$iv;
        boolean bl2 = false;
        Iterator<Map.Entry<LanguageFeature, LanguageFeature.State>> iterator2 = map2.entrySet().iterator();
        do {
            Map.Entry<LanguageFeature, LanguageFeature.State> element$iv;
            if (!iterator2.hasNext()) return false;
            Map.Entry<LanguageFeature, LanguageFeature.State> $dstr$feature$state = element$iv = iterator2.next();
            boolean bl3 = false;
            Map.Entry<LanguageFeature, LanguageFeature.State> entry = $dstr$feature$state;
            boolean bl4 = false;
            LanguageFeature feature = entry.getKey();
            entry = $dstr$feature$state;
            bl4 = false;
            LanguageFeature.State state = entry.getValue();
            if (state == LanguageFeature.State.ENABLED && LanguageVersionSettingsKt.forcesPreReleaseBinariesIfEnabled(feature)) {
                return true;
            }
            bl = false;
        } while (!bl);
        return true;
    }

    @Override
    @NotNull
    public LanguageVersion getLanguageVersion() {
        return this.languageVersion;
    }

    @Override
    @NotNull
    public ApiVersion getApiVersion() {
        return this.apiVersion;
    }

    @JvmOverloads
    public LanguageVersionSettingsImpl(@NotNull LanguageVersion languageVersion, @NotNull ApiVersion apiVersion, @NotNull Map<AnalysisFlag<?>, ? extends Object> analysisFlags, @NotNull Map<LanguageFeature, ? extends LanguageFeature.State> specificFeatures) {
        Intrinsics.checkParameterIsNotNull((Object)languageVersion, (String)"languageVersion");
        Intrinsics.checkParameterIsNotNull((Object)apiVersion, (String)"apiVersion");
        Intrinsics.checkParameterIsNotNull(analysisFlags, (String)"analysisFlags");
        Intrinsics.checkParameterIsNotNull(specificFeatures, (String)"specificFeatures");
        this.languageVersion = languageVersion;
        this.apiVersion = apiVersion;
        Map<AnalysisFlag<?>, ? extends Object> map2 = Collections.unmodifiableMap(analysisFlags);
        Intrinsics.checkExpressionValueIsNotNull(map2, (String)"Collections.unmodifiableMap(analysisFlags)");
        this.analysisFlags = map2;
        Map<LanguageFeature, ? extends LanguageFeature.State> map3 = Collections.unmodifiableMap(specificFeatures);
        Intrinsics.checkExpressionValueIsNotNull(map3, (String)"Collections.unmodifiableMap(specificFeatures)");
        this.specificFeatures = map3;
    }

    public /* synthetic */ LanguageVersionSettingsImpl(LanguageVersion languageVersion, ApiVersion apiVersion, Map map2, Map map3, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            map2 = MapsKt.emptyMap();
        }
        if ((n & 8) != 0) {
            map3 = MapsKt.emptyMap();
        }
        this(languageVersion, apiVersion, map2, map3);
    }

    @JvmOverloads
    public LanguageVersionSettingsImpl(@NotNull LanguageVersion languageVersion, @NotNull ApiVersion apiVersion, @NotNull Map<AnalysisFlag<?>, ? extends Object> analysisFlags) {
        this(languageVersion, apiVersion, analysisFlags, null, 8, null);
    }

    @JvmOverloads
    public LanguageVersionSettingsImpl(@NotNull LanguageVersion languageVersion, @NotNull ApiVersion apiVersion) {
        this(languageVersion, apiVersion, null, null, 12, null);
    }

    static {
        Companion = new Companion(null);
        DEFAULT = new LanguageVersionSettingsImpl(LanguageVersion.LATEST_STABLE, ApiVersion.LATEST_STABLE, null, null, 12, null);
    }

    @Override
    public boolean supportsFeature(@NotNull LanguageFeature feature) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)feature), (String)"feature");
        return LanguageVersionSettings.DefaultImpls.supportsFeature(this, feature);
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/kotlin/config/LanguageVersionSettingsImpl$Companion;", "", "()V", "DEFAULT", "Lorg/jetbrains/kotlin/config/LanguageVersionSettingsImpl;", "util"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

