/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.FunctionTypesKt;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.contracts.EffectSystem;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.psi.Call;
import org.jetbrains.kotlin.psi.KtAnnotatedExpression;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtCallableReferenceExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtLabeledExpression;
import org.jetbrains.kotlin.psi.KtParenthesizedExpression;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.psi.KtSafeQualifiedExpression;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingContextUtils;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.ImplicitIntegerCoercion;
import org.jetbrains.kotlin.resolve.RecursiveContractHelperKt;
import org.jetbrains.kotlin.resolve.StatementFilter;
import org.jetbrains.kotlin.resolve.StatementFilterKt;
import org.jetbrains.kotlin.resolve.TemporaryBindingTrace;
import org.jetbrains.kotlin.resolve.calls.ArgumentTypeResolver;
import org.jetbrains.kotlin.resolve.calls.CallCompleter;
import org.jetbrains.kotlin.resolve.calls.CandidateResolver;
import org.jetbrains.kotlin.resolve.calls.GenericCandidateResolverKt;
import org.jetbrains.kotlin.resolve.calls.callResolverUtil.CallResolverUtilKt;
import org.jetbrains.kotlin.resolve.calls.callResolverUtil.ResolveArgumentsMode;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.checkers.CallChecker;
import org.jetbrains.kotlin.resolve.calls.checkers.CallCheckerContext;
import org.jetbrains.kotlin.resolve.calls.context.BasicCallResolutionContext;
import org.jetbrains.kotlin.resolve.calls.context.CallCandidateResolutionContext;
import org.jetbrains.kotlin.resolve.calls.context.CallPosition;
import org.jetbrains.kotlin.resolve.calls.context.CheckArgumentTypesMode;
import org.jetbrains.kotlin.resolve.calls.context.ResolutionContext;
import org.jetbrains.kotlin.resolve.calls.context.ResolutionResultsCache;
import org.jetbrains.kotlin.resolve.calls.inference.CallHandle;
import org.jetbrains.kotlin.resolve.calls.inference.ConstraintSystem;
import org.jetbrains.kotlin.resolve.calls.inference.ConstraintSystemCompleter;
import org.jetbrains.kotlin.resolve.calls.inference.ConstraintSystemStatus;
import org.jetbrains.kotlin.resolve.calls.inference.ConstraintSystemUtilsKt;
import org.jetbrains.kotlin.resolve.calls.inference.InferenceErrorData;
import org.jetbrains.kotlin.resolve.calls.inference.TypeVariableKt;
import org.jetbrains.kotlin.resolve.calls.inference.constraintPosition.ConstraintPositionKind;
import org.jetbrains.kotlin.resolve.calls.model.ArgumentMapping;
import org.jetbrains.kotlin.resolve.calls.model.ArgumentMatch;
import org.jetbrains.kotlin.resolve.calls.model.MutableDataFlowInfoForArguments;
import org.jetbrains.kotlin.resolve.calls.model.MutableResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.VariableAsFunctionResolvedCall;
import org.jetbrains.kotlin.resolve.calls.resolvedCallUtil.ResolvedCallUtilKt;
import org.jetbrains.kotlin.resolve.calls.results.OverloadResolutionResultsImpl;
import org.jetbrains.kotlin.resolve.calls.results.ResolutionStatus;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowInfo;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowValueFactory;
import org.jetbrains.kotlin.resolve.calls.tasks.TracingStrategy;
import org.jetbrains.kotlin.resolve.constants.CompileTimeConstant;
import org.jetbrains.kotlin.resolve.constants.IntegerValueTypeConstant;
import org.jetbrains.kotlin.resolve.constants.IntegerValueTypeConstructor;
import org.jetbrains.kotlin.resolve.deprecation.DeprecationResolver;
import org.jetbrains.kotlin.resolve.scopes.LexicalScope;
import org.jetbrains.kotlin.resolve.scopes.MemberScope;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.kotlin.types.ErrorUtils;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.KotlinTypeFactory;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.TypeConstructor;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.TypeSubstitutor;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.Variance;
import org.jetbrains.kotlin.types.expressions.DataFlowAnalyzer;
import org.jetbrains.kotlin.util.slicedMap.ReadOnlySlice;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u00a6\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001BK\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u0012\u0006\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\u0002\u0010\u0013J(\u0010\u0014\u001a\u00020\u0015\"\b\b\u0000\u0010\u0016*\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u0002H\u00160\u001bH\u0002J(\u0010\u001c\u001a\u00020\u0015\"\b\b\u0000\u0010\u0016*\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u0002H\u00160\u001bH\u0002J4\u0010\u001d\u001a\b\u0012\u0004\u0012\u0002H\u00160\u001b\"\b\b\u0000\u0010\u0016*\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u0002H\u00160\u001b2\u0006\u0010\u001e\u001a\u00020\u001fJ\u001e\u0010 \u001a\b\u0012\u0002\b\u0003\u0018\u00010\u001b2\u0006\u0010!\u001a\u00020\"2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\"\u0010#\u001a\u00020\u00152\u0006\u0010$\u001a\u00020%2\b\u0010&\u001a\u0004\u0018\u00010'2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J@\u0010(\u001a\u00020\u0015\"\b\b\u0000\u0010\u0016*\u00020\u00172\u000e\u0010)\u001a\n\u0012\u0004\u0012\u0002H\u0016\u0018\u00010*2\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u0002H\u00160\u001b2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u0016\u0010+\u001a\u0004\u0018\u00010,2\n\u0010-\u001a\u0006\u0012\u0002\b\u00030.H\u0002J\u0018\u0010/\u001a\u0002002\u0006\u0010!\u001a\u00020\"2\u0006\u00101\u001a\u000202H\u0002J6\u00103\u001a\u0004\u0018\u0001042\b\u00105\u001a\u0004\u0018\u0001042\b\u00106\u001a\u0004\u0018\u0001042\u0006\u00107\u001a\u00020\"2\u0006\u00108\u001a\u0002092\u0006\u00101\u001a\u000202H\u0002J,\u0010:\u001a\u00020\u0015\"\b\b\u0000\u0010\u0016*\u00020\u0017*\b\u0012\u0004\u0012\u0002H\u00160*2\u0006\u0010;\u001a\u0002042\u0006\u00101\u001a\u000202H\u0002J,\u0010<\u001a\u00020\u0015\"\b\b\u0000\u0010\u0016*\u00020\u0017*\b\u0012\u0004\u0012\u0002H\u00160*2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u0018\u0010=\u001a\u00020\u0015*\u0006\u0012\u0002\b\u00030*2\u0006\u0010>\u001a\u000202H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006?"}, d2={"Lorg/jetbrains/kotlin/resolve/calls/CallCompleter;", "", "argumentTypeResolver", "Lorg/jetbrains/kotlin/resolve/calls/ArgumentTypeResolver;", "candidateResolver", "Lorg/jetbrains/kotlin/resolve/calls/CandidateResolver;", "dataFlowAnalyzer", "Lorg/jetbrains/kotlin/types/expressions/DataFlowAnalyzer;", "callCheckers", "", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallChecker;", "moduleDescriptor", "Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "deprecationResolver", "Lorg/jetbrains/kotlin/resolve/deprecation/DeprecationResolver;", "effectSystem", "Lorg/jetbrains/kotlin/contracts/EffectSystem;", "dataFlowValueFactory", "Lorg/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValueFactory;", "(Lorg/jetbrains/kotlin/resolve/calls/ArgumentTypeResolver;Lorg/jetbrains/kotlin/resolve/calls/CandidateResolver;Lorg/jetbrains/kotlin/types/expressions/DataFlowAnalyzer;Ljava/lang/Iterable;Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;Lorg/jetbrains/kotlin/resolve/deprecation/DeprecationResolver;Lorg/jetbrains/kotlin/contracts/EffectSystem;Lorg/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValueFactory;)V", "completeAllCandidates", "", "D", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "context", "Lorg/jetbrains/kotlin/resolve/calls/context/BasicCallResolutionContext;", "results", "Lorg/jetbrains/kotlin/resolve/calls/results/OverloadResolutionResultsImpl;", "completeArguments", "completeCall", "tracing", "Lorg/jetbrains/kotlin/resolve/calls/tasks/TracingStrategy;", "completeCallForArgument", "expression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "completeOneArgument", "argument", "Lorg/jetbrains/kotlin/psi/ValueArgument;", "parameter", "Lorg/jetbrains/kotlin/descriptors/ValueParameterDescriptor;", "completeResolvedCallAndArguments", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/MutableResolvedCall;", "createTypeForConvertableConstant", "Lorg/jetbrains/kotlin/types/SimpleType;", "constant", "Lorg/jetbrains/kotlin/resolve/constants/CompileTimeConstant;", "hasNecessarySafeCall", "", "trace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "updateRecordedTypeForArgument", "Lorg/jetbrains/kotlin/types/KotlinType;", "updatedType", "recordedType", "argumentExpression", "statementFilter", "Lorg/jetbrains/kotlin/resolve/StatementFilter;", "completeConstraintSystem", "expectedType", "updateResolutionStatusFromConstraintSystem", "updateResultDataFlowInfoUsingEffects", "bindingTrace", "frontend"})
public final class CallCompleter {
    private final ArgumentTypeResolver argumentTypeResolver;
    private final CandidateResolver candidateResolver;
    private final DataFlowAnalyzer dataFlowAnalyzer;
    private final Iterable<CallChecker> callCheckers;
    private final ModuleDescriptor moduleDescriptor;
    private final DeprecationResolver deprecationResolver;
    private final EffectSystem effectSystem;
    private final DataFlowValueFactory dataFlowValueFactory;

    @NotNull
    public final <D extends CallableDescriptor> OverloadResolutionResultsImpl<D> completeCall(@NotNull BasicCallResolutionContext context2, @NotNull OverloadResolutionResultsImpl<D> results, @NotNull TracingStrategy tracing) {
        Intrinsics.checkParameterIsNotNull((Object)context2, (String)"context");
        Intrinsics.checkParameterIsNotNull(results, (String)"results");
        Intrinsics.checkParameterIsNotNull((Object)tracing, (String)"tracing");
        ResolvedCall resolvedCall2 = results.isSingleResult() ? results.getResultingCall() : null;
        Call call2 = context2.call;
        Intrinsics.checkExpressionValueIsNotNull((Object)call2, (String)"context.call");
        if (!CallResolverUtilKt.isInvokeCallOnVariable(call2)) {
            this.completeResolvedCallAndArguments((MutableResolvedCall<D>)resolvedCall2, results, context2, tracing);
            this.completeAllCandidates(context2, results);
        }
        if (resolvedCall2 != null && context2.trace.wantsDiagnostics()) {
            KtElement ktElement;
            KtExpression calleeExpression;
            KtExpression ktExpression;
            if (resolvedCall2 instanceof VariableAsFunctionResolvedCall) {
                Call call3 = ((VariableAsFunctionResolvedCall)((Object)resolvedCall2)).getVariableCall().getCall();
                Intrinsics.checkExpressionValueIsNotNull((Object)call3, (String)"resolvedCall.variableCall.call");
                ktExpression = call3.getCalleeExpression();
            } else {
                Call call4 = resolvedCall2.getCall();
                Intrinsics.checkExpressionValueIsNotNull((Object)call4, (String)"resolvedCall.call");
                ktExpression = calleeExpression = call4.getCalleeExpression();
            }
            if (calleeExpression != null && !CallUtilKt.isFakeElement(calleeExpression)) {
                ktElement = calleeExpression;
            } else {
                Call call5 = resolvedCall2.getCall();
                Intrinsics.checkExpressionValueIsNotNull((Object)call5, (String)"resolvedCall.call");
                ktElement = call5.getCallElement();
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)ktElement, (String)"if (calleeExpression != \u2026lvedCall.call.callElement");
            KtElement reportOn = ktElement;
            CallCheckerContext callCheckerContext = new CallCheckerContext(context2, this.deprecationResolver, this.moduleDescriptor, null, 8, null);
            for (CallChecker callChecker : this.callCheckers) {
                callChecker.check(resolvedCall2, reportOn, callCheckerContext);
                if (!(resolvedCall2 instanceof VariableAsFunctionResolvedCall)) continue;
                callChecker.check(((VariableAsFunctionResolvedCall)((Object)resolvedCall2)).getVariableCall(), reportOn, callCheckerContext);
            }
        }
        if (results.isSingleResult()) {
            ResolvedCall resolvedCall3 = results.getResultingCall();
            Intrinsics.checkExpressionValueIsNotNull((Object)resolvedCall3, (String)"results.resultingCall");
            ResolutionStatus resolutionStatus = resolvedCall3.getStatus();
            Intrinsics.checkExpressionValueIsNotNull((Object)((Object)resolutionStatus), (String)"results.resultingCall.status");
            if (resolutionStatus.isSuccess()) {
                OverloadResolutionResultsImpl<D> overloadResolutionResultsImpl = results.changeStatusToSuccess();
                Intrinsics.checkExpressionValueIsNotNull(overloadResolutionResultsImpl, (String)"results.changeStatusToSuccess()");
                return overloadResolutionResultsImpl;
            }
        }
        return results;
    }

    /*
     * WARNING - void declaration
     */
    private final <D extends CallableDescriptor> void completeAllCandidates(BasicCallResolutionContext context2, OverloadResolutionResultsImpl<D> results) {
        void $this$filterNotTo$iv$iv;
        Collection<ResolvedCall<D>> collection;
        if (context2.collectAllCandidates) {
            Collection<ResolvedCall<D>> collection2 = results.getAllCandidates();
            if (collection2 == null) {
                Intrinsics.throwNpe();
            }
            collection = collection2;
            Intrinsics.checkExpressionValueIsNotNull(collection2, (String)"results.allCandidates!!");
        } else {
            Collection<MutableResolvedCall<D>> collection3 = results.getResultingCalls();
            collection = collection3;
            Intrinsics.checkExpressionValueIsNotNull(collection3, (String)"results.resultingCalls");
        }
        if (collection == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.Collection<org.jetbrains.kotlin.resolve.calls.model.MutableResolvedCall<D>>");
        }
        Collection<ResolvedCall<D>> candidates2 = collection;
        TemporaryBindingTrace temporaryBindingTrace = TemporaryBindingTrace.create(context2.trace, "Trace to complete a candidate that is not a resulting call");
        Intrinsics.checkExpressionValueIsNotNull((Object)temporaryBindingTrace, (String)"TemporaryBindingTrace.cr\u2026is not a resulting call\")");
        TemporaryBindingTrace temporaryBindingTrace2 = temporaryBindingTrace;
        Iterable $this$filterNot$iv = candidates2;
        boolean $i$f$filterNot = false;
        Iterable iterable = $this$filterNot$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            MutableResolvedCall resolvedCall2 = (MutableResolvedCall)element$iv$iv;
            boolean bl = false;
            if (resolvedCall2.isCompleted()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            MutableResolvedCall resolvedCall3 = (MutableResolvedCall)element$iv;
            boolean bl = false;
            Object Context2 = context2.replaceBindingTrace(temporaryBindingTrace2);
            Intrinsics.checkExpressionValueIsNotNull(Context2, (String)"context.replaceBindingTrace(temporaryBindingTrace)");
            BasicCallResolutionContext basicCallResolutionContext = (BasicCallResolutionContext)Context2;
            TracingStrategy tracingStrategy = TracingStrategy.EMPTY;
            Intrinsics.checkExpressionValueIsNotNull((Object)tracingStrategy, (String)"TracingStrategy.EMPTY");
            this.completeResolvedCallAndArguments(resolvedCall3, results, basicCallResolutionContext, tracingStrategy);
        }
    }

    private final <D extends CallableDescriptor> void completeResolvedCallAndArguments(MutableResolvedCall<D> resolvedCall2, OverloadResolutionResultsImpl<D> results, BasicCallResolutionContext context2, TracingStrategy tracing) {
        Call call2 = context2.call;
        Intrinsics.checkExpressionValueIsNotNull((Object)call2, (String)"context.call");
        MutableResolvedCall<D> mutableResolvedCall = resolvedCall2;
        Object object = mutableResolvedCall != null ? mutableResolvedCall.getResultingDescriptor() : null;
        LexicalScope lexicalScope = context2.scope;
        Intrinsics.checkExpressionValueIsNotNull((Object)lexicalScope, (String)"context.scope");
        BindingTrace bindingTrace = context2.trace;
        Intrinsics.checkExpressionValueIsNotNull((Object)bindingTrace, (String)"context.trace");
        RecursiveContractHelperKt.disableContractsInsideContractsBlock(call2, object, lexicalScope, bindingTrace);
        if (resolvedCall2 == null || resolvedCall2.isCompleted() || resolvedCall2.getConstraintSystem() == null) {
            this.completeArguments(context2, results);
            MutableResolvedCall<D> mutableResolvedCall2 = resolvedCall2;
            if (mutableResolvedCall2 != null) {
                BindingTrace bindingTrace2 = context2.trace;
                Intrinsics.checkExpressionValueIsNotNull((Object)bindingTrace2, (String)"context.trace");
                this.updateResultDataFlowInfoUsingEffects(mutableResolvedCall2, bindingTrace2);
            }
            MutableResolvedCall<D> mutableResolvedCall3 = resolvedCall2;
            if (mutableResolvedCall3 != null) {
                mutableResolvedCall3.markCallAsCompleted();
            }
            return;
        }
        KotlinType kotlinType2 = context2.expectedType;
        Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType2, (String)"context.expectedType");
        BindingTrace bindingTrace3 = context2.trace;
        Intrinsics.checkExpressionValueIsNotNull((Object)bindingTrace3, (String)"context.trace");
        this.completeConstraintSystem(resolvedCall2, kotlinType2, bindingTrace3);
        this.completeArguments(context2, results);
        this.updateResolutionStatusFromConstraintSystem(resolvedCall2, context2, tracing);
        BindingTrace bindingTrace4 = context2.trace;
        Intrinsics.checkExpressionValueIsNotNull((Object)bindingTrace4, (String)"context.trace");
        this.updateResultDataFlowInfoUsingEffects(resolvedCall2, bindingTrace4);
        resolvedCall2.markCallAsCompleted();
    }

    private final <D extends CallableDescriptor> void completeConstraintSystem(@NotNull MutableResolvedCall<D> $this$completeConstraintSystem, KotlinType expectedType, BindingTrace trace) {
        KotlinType kotlinType2;
        Object d = $this$completeConstraintSystem.getCandidateDescriptor();
        Intrinsics.checkExpressionValueIsNotNull(d, (String)"candidateDescriptor");
        KotlinType returnType2 = d.getReturnType();
        Call call2 = $this$completeConstraintSystem.getCall();
        Intrinsics.checkExpressionValueIsNotNull((Object)call2, (String)"call");
        if (CallUtilKt.isCallableReference(call2)) {
            if (!TypeUtils.noExpectedType(expectedType) && FunctionTypesKt.isFunctionOrSuspendFunctionType(expectedType)) {
                kotlinType2 = FunctionTypesKt.getReturnTypeFromFunctionType(expectedType);
            } else {
                SimpleType simpleType2 = TypeUtils.NO_EXPECTED_TYPE;
                Intrinsics.checkExpressionValueIsNotNull((Object)simpleType2, (String)"TypeUtils.NO_EXPECTED_TYPE");
                kotlinType2 = simpleType2;
            }
        } else {
            kotlinType2 = expectedType;
        }
        KotlinType expectedReturnType = kotlinType2;
        Function2<ConstraintSystem.Builder, KotlinType, KotlinType> $fun$typeInSystem$1 = new Function2<ConstraintSystem.Builder, KotlinType, KotlinType>($this$completeConstraintSystem){
            final /* synthetic */ MutableResolvedCall $this_completeConstraintSystem;

            @Nullable
            public final KotlinType invoke(@NotNull ConstraintSystem.Builder $this$typeInSystem, @Nullable KotlinType type2) {
                KotlinType kotlinType2;
                Intrinsics.checkParameterIsNotNull((Object)$this$typeInSystem, (String)"$this$typeInSystem");
                KotlinType kotlinType3 = type2;
                if (kotlinType3 != null) {
                    KotlinType kotlinType4 = kotlinType3;
                    boolean bl = false;
                    boolean bl2 = false;
                    KotlinType it = kotlinType4;
                    boolean bl3 = false;
                    Map<CallHandle, TypeSubstitutor> map2 = $this$typeInSystem.getTypeVariableSubstitutors();
                    Call call2 = this.$this_completeConstraintSystem.getCall();
                    Intrinsics.checkExpressionValueIsNotNull((Object)call2, (String)"call");
                    TypeSubstitutor typeSubstitutor2 = map2.get(TypeVariableKt.toHandle(call2));
                    if (typeSubstitutor2 == null) {
                        String string2 = "No substitutor for call: " + this.$this_completeConstraintSystem.getCall();
                        boolean bl4 = false;
                        throw (Throwable)new IllegalStateException(string2.toString());
                    }
                    TypeSubstitutor substitutor2 = typeSubstitutor2;
                    kotlinType2 = substitutor2.substitute(it, Variance.INVARIANT);
                } else {
                    kotlinType2 = null;
                }
                return kotlinType2;
            }
            {
                this.$this_completeConstraintSystem = mutableResolvedCall;
                super(2);
            }
        };
        Function1<Function1<? super ConstraintSystem.Builder, ? extends ConstraintSystem>, Unit> $fun$updateSystemIfNeeded$2 = new Function1<Function1<? super ConstraintSystem.Builder, ? extends ConstraintSystem>, Unit>($this$completeConstraintSystem){
            final /* synthetic */ MutableResolvedCall $this_completeConstraintSystem;

            public final void invoke(@NotNull Function1<? super ConstraintSystem.Builder, ? extends ConstraintSystem> buildSystemWithAdditionalConstraints) {
                ConstraintSystem system2;
                Intrinsics.checkParameterIsNotNull(buildSystemWithAdditionalConstraints, (String)"buildSystemWithAdditionalConstraints");
                ConstraintSystem constraintSystem = this.$this_completeConstraintSystem.getConstraintSystem();
                if (constraintSystem == null) {
                    Intrinsics.throwNpe();
                }
                if ((system2 = (ConstraintSystem)buildSystemWithAdditionalConstraints.invoke((Object)ConstraintSystem.DefaultImpls.toBuilder$default(constraintSystem, null, 1, null))) != null) {
                    this.$this_completeConstraintSystem.setConstraintSystem(system2);
                }
            }
            {
                this.$this_completeConstraintSystem = mutableResolvedCall;
                super(1);
            }
        };
        if (returnType2 != null && !TypeUtils.noExpectedType(expectedReturnType)) {
            $fun$updateSystemIfNeeded$2.invoke((Function1<? super ConstraintSystem.Builder, ? extends ConstraintSystem>)((Function1)new Function1<ConstraintSystem.Builder, ConstraintSystem>($fun$typeInSystem$1, returnType2, expectedReturnType){
                final /* synthetic */ completeConstraintSystem.1 $typeInSystem$1;
                final /* synthetic */ KotlinType $returnType;
                final /* synthetic */ KotlinType $expectedReturnType;

                @Nullable
                public final ConstraintSystem invoke(@NotNull ConstraintSystem.Builder builder) {
                    ConstraintSystem constraintSystem;
                    Intrinsics.checkParameterIsNotNull((Object)builder, (String)"builder");
                    KotlinType returnTypeInSystem = this.$typeInSystem$1.invoke(builder, this.$returnType);
                    if (returnTypeInSystem != null) {
                        builder.addSubtypeConstraint(returnTypeInSystem, this.$expectedReturnType, ConstraintPositionKind.EXPECTED_TYPE_POSITION.position());
                        constraintSystem = builder.build();
                    } else {
                        constraintSystem = null;
                    }
                    return constraintSystem;
                }
                {
                    this.$typeInSystem$1 = var1_1;
                    this.$returnType = kotlinType2;
                    this.$expectedReturnType = kotlinType3;
                    super(1);
                }
            }));
        }
        ReadOnlySlice readOnlySlice = BindingContext.CONSTRAINT_SYSTEM_COMPLETER;
        Call call3 = $this$completeConstraintSystem.getCall();
        Intrinsics.checkExpressionValueIsNotNull((Object)call3, (String)"call");
        ConstraintSystemCompleter constraintSystemCompleter = (ConstraintSystemCompleter)trace.get(readOnlySlice, call3.getCalleeExpression());
        if (constraintSystemCompleter != null) {
            $fun$updateSystemIfNeeded$2.invoke((Function1<? super ConstraintSystem.Builder, ? extends ConstraintSystem>)((Function1)new Function1<ConstraintSystem.Builder, ConstraintSystem>($this$completeConstraintSystem, constraintSystemCompleter){
                final /* synthetic */ MutableResolvedCall $this_completeConstraintSystem;
                final /* synthetic */ ConstraintSystemCompleter $constraintSystemCompleter;

                /*
                 * WARNING - void declaration
                 */
                @Nullable
                public final ConstraintSystem invoke(@NotNull ConstraintSystem.Builder builder) {
                    void var2_2;
                    Intrinsics.checkParameterIsNotNull((Object)builder, (String)"builder");
                    this.$constraintSystemCompleter.completeConstraintSystem(builder, this.$this_completeConstraintSystem);
                    ConstraintSystem system2 = builder.build();
                    ConstraintSystemStatus status2 = ConstraintSystemUtilsKt.filterConstraintsOut(system2, ConstraintPositionKind.TYPE_BOUND_POSITION).getStatus();
                    return status2.hasOnlyErrorsDerivedFrom(ConstraintPositionKind.FROM_COMPLETER) ? null : var2_2;
                }
                {
                    this.$this_completeConstraintSystem = mutableResolvedCall;
                    this.$constraintSystemCompleter = constraintSystemCompleter;
                    super(1);
                }
            }));
        }
        if (returnType2 != null && expectedReturnType == TypeUtils.UNIT_EXPECTED_TYPE) {
            $fun$updateSystemIfNeeded$2.invoke((Function1<? super ConstraintSystem.Builder, ? extends ConstraintSystem>)((Function1)new Function1<ConstraintSystem.Builder, ConstraintSystem>(this, $fun$typeInSystem$1, returnType2){
                final /* synthetic */ CallCompleter this$0;
                final /* synthetic */ completeConstraintSystem.1 $typeInSystem$1;
                final /* synthetic */ KotlinType $returnType;

                @Nullable
                public final ConstraintSystem invoke(@NotNull ConstraintSystem.Builder builder) {
                    ConstraintSystem constraintSystem;
                    Intrinsics.checkParameterIsNotNull((Object)builder, (String)"builder");
                    KotlinType returnTypeInSystem = this.$typeInSystem$1.invoke(builder, this.$returnType);
                    if (returnTypeInSystem != null) {
                        builder.addSubtypeConstraint(returnTypeInSystem, CallCompleter.access$getModuleDescriptor$p(this.this$0).getBuiltIns().getUnitType(), ConstraintPositionKind.EXPECTED_TYPE_POSITION.position());
                        ConstraintSystem system2 = builder.build();
                        constraintSystem = system2.getStatus().isSuccessful() ? system2 : null;
                    } else {
                        constraintSystem = null;
                    }
                    return constraintSystem;
                }
                {
                    this.this$0 = callCompleter;
                    this.$typeInSystem$1 = var2_2;
                    this.$returnType = kotlinType2;
                    super(1);
                }
            }));
        }
        Call call4 = $this$completeConstraintSystem.getCall();
        Intrinsics.checkExpressionValueIsNotNull((Object)call4, (String)"call");
        if (CallUtilKt.isCallableReference(call4) && !TypeUtils.noExpectedType(expectedType) && FunctionTypesKt.isFunctionOrSuspendFunctionType(expectedType)) {
            $fun$updateSystemIfNeeded$2.invoke((Function1<? super ConstraintSystem.Builder, ? extends ConstraintSystem>)((Function1)new Function1<ConstraintSystem.Builder, ConstraintSystem>($this$completeConstraintSystem, expectedType, $fun$typeInSystem$1){
                final /* synthetic */ MutableResolvedCall $this_completeConstraintSystem;
                final /* synthetic */ KotlinType $expectedType;
                final /* synthetic */ completeConstraintSystem.1 $typeInSystem$1;

                @Nullable
                public final ConstraintSystem invoke(@NotNull ConstraintSystem.Builder builder) {
                    Intrinsics.checkParameterIsNotNull((Object)builder, (String)"builder");
                    D d = this.$this_completeConstraintSystem.getCandidateDescriptor();
                    Intrinsics.checkExpressionValueIsNotNull(d, (String)"candidateDescriptor");
                    List<ValueParameterDescriptor> list2 = d.getValueParameters();
                    Intrinsics.checkExpressionValueIsNotNull(list2, (String)"candidateDescriptor.valueParameters");
                    Iterable $this$forEach$iv = CollectionsKt.zip((Iterable)list2, (Iterable)FunctionTypesKt.getValueParameterTypesFromFunctionType(this.$expectedType));
                    boolean $i$f$forEach = false;
                    for (T element$iv : $this$forEach$iv) {
                        Pair $dstr$parameter$argument = (Pair)element$iv;
                        boolean bl = false;
                        ValueParameterDescriptor parameter = (ValueParameterDescriptor)$dstr$parameter$argument.component1();
                        TypeProjection argument = (TypeProjection)$dstr$parameter$argument.component2();
                        ValueParameterDescriptor valueParameterDescriptor = parameter;
                        Intrinsics.checkExpressionValueIsNotNull((Object)valueParameterDescriptor, (String)"parameter");
                        KotlinType valueParameterInSystem = this.$typeInSystem$1.invoke(builder, valueParameterDescriptor.getType());
                        builder.addSubtypeConstraint(valueParameterInSystem, argument.getType(), ConstraintPositionKind.VALUE_PARAMETER_POSITION.position(parameter.getIndex()));
                    }
                    return builder.build();
                }
                {
                    this.$this_completeConstraintSystem = mutableResolvedCall;
                    this.$expectedType = kotlinType2;
                    this.$typeInSystem$1 = var3_3;
                    super(1);
                }
            }));
        }
        ConstraintSystem constraintSystem = $this$completeConstraintSystem.getConstraintSystem();
        if (constraintSystem == null) {
            Intrinsics.throwNpe();
        }
        ConstraintSystem.Builder builder = ConstraintSystem.DefaultImpls.toBuilder$default(constraintSystem, null, 1, null);
        builder.fixVariables();
        ConstraintSystem system2 = builder.build();
        $this$completeConstraintSystem.setConstraintSystem(system2);
        $this$completeConstraintSystem.setResultingSubstitutor(system2.getResultingSubstitutor());
    }

    private final <D extends CallableDescriptor> void updateResolutionStatusFromConstraintSystem(@NotNull MutableResolvedCall<D> $this$updateResolutionStatusFromConstraintSystem, BasicCallResolutionContext context2, TracingStrategy tracing) {
        CallCandidateResolutionContext<D> callCandidateResolutionContext = CallCandidateResolutionContext.createForCallBeingAnalyzed($this$updateResolutionStatusFromConstraintSystem, context2, tracing);
        Intrinsics.checkExpressionValueIsNotNull(callCandidateResolutionContext, (String)"CallCandidateResolutionC\u2026d(this, context, tracing)");
        CallCandidateResolutionContext<D> contextWithResolvedCall = callCandidateResolutionContext;
        CandidateResolver.ValueArgumentsCheckingResult valueArgumentsCheckingResult = this.candidateResolver.checkAllValueArguments(contextWithResolvedCall, ResolveArgumentsMode.RESOLVE_FUNCTION_ARGUMENTS);
        ResolutionStatus resolutionStatus = $this$updateResolutionStatusFromConstraintSystem.getStatus();
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)resolutionStatus), (String)"status");
        ResolutionStatus status2 = resolutionStatus;
        ConstraintSystem constraintSystem = $this$updateResolutionStatusFromConstraintSystem.getConstraintSystem();
        if (constraintSystem == null) {
            Intrinsics.throwNpe();
        }
        if (constraintSystem.getStatus().isSuccessful()) {
            if (status2 == ResolutionStatus.UNKNOWN_STATUS || status2 == ResolutionStatus.INCOMPLETE_TYPE_INFERENCE) {
                $this$updateResolutionStatusFromConstraintSystem.setStatusToSuccess();
            }
            return;
        }
        ReceiverValue receiverValue = $this$updateResolutionStatusFromConstraintSystem.getExtensionReceiver();
        KotlinType receiverType = receiverValue != null ? receiverValue.getType() : null;
        Object d = $this$updateResolutionStatusFromConstraintSystem.getCandidateDescriptor();
        ConstraintSystem constraintSystem2 = $this$updateResolutionStatusFromConstraintSystem.getConstraintSystem();
        if (constraintSystem2 == null) {
            Intrinsics.throwNpe();
        }
        InferenceErrorData inferenceErrorData = InferenceErrorData.create(d, constraintSystem2, valueArgumentsCheckingResult.getArgumentTypes(), receiverType, context2.expectedType, context2.call);
        Intrinsics.checkExpressionValueIsNotNull((Object)inferenceErrorData, (String)"InferenceErrorData.creat\u2026e, context.call\n        )");
        InferenceErrorData errorData = inferenceErrorData;
        tracing.typeInferenceFailed(context2, errorData);
        $this$updateResolutionStatusFromConstraintSystem.addStatus(ResolutionStatus.OTHER_ERROR);
    }

    private final <D extends CallableDescriptor> void completeArguments(BasicCallResolutionContext context2, OverloadResolutionResultsImpl<D> results) {
        if (context2.checkArguments != CheckArgumentTypesMode.CHECK_VALUE_ARGUMENTS) {
            return;
        }
        Function1 getArgumentMapping = null;
        Function1 getDataFlowInfoForArgument = null;
        if (results.isSingleResult()) {
            ResolvedCall resolvedCall2 = results.getResultingCall();
            Intrinsics.checkExpressionValueIsNotNull((Object)resolvedCall2, (String)"results.resultingCall");
            ResolvedCall resolvedCall3 = resolvedCall2;
            getArgumentMapping = (Function1)new Function1<ValueArgument, ArgumentMapping>((MutableResolvedCall)resolvedCall3){
                final /* synthetic */ MutableResolvedCall $resolvedCall;

                @NotNull
                public final ArgumentMapping invoke(@NotNull ValueArgument argument) {
                    Intrinsics.checkParameterIsNotNull((Object)argument, (String)"argument");
                    ArgumentMapping argumentMapping = this.$resolvedCall.getArgumentMapping(argument);
                    Intrinsics.checkExpressionValueIsNotNull((Object)argumentMapping, (String)"resolvedCall.getArgumentMapping(argument)");
                    return argumentMapping;
                }
                {
                    this.$resolvedCall = mutableResolvedCall;
                    super(1);
                }
            };
            getDataFlowInfoForArgument = (Function1)new Function1<ValueArgument, DataFlowInfo>((MutableResolvedCall)resolvedCall3){
                final /* synthetic */ MutableResolvedCall $resolvedCall;

                @NotNull
                public final DataFlowInfo invoke(@NotNull ValueArgument argument) {
                    Intrinsics.checkParameterIsNotNull((Object)argument, (String)"argument");
                    DataFlowInfo dataFlowInfo = this.$resolvedCall.getDataFlowInfoForArguments().getInfo(argument);
                    Intrinsics.checkExpressionValueIsNotNull((Object)dataFlowInfo, (String)"resolvedCall.dataFlowInf\u2026guments.getInfo(argument)");
                    return dataFlowInfo;
                }
                {
                    this.$resolvedCall = mutableResolvedCall;
                    super(1);
                }
            };
        } else {
            getArgumentMapping = completeArguments.3.INSTANCE;
            getDataFlowInfoForArgument = (Function1)new Function1<ValueArgument, DataFlowInfo>(context2){
                final /* synthetic */ BasicCallResolutionContext $context;

                @NotNull
                public final DataFlowInfo invoke(@NotNull ValueArgument it) {
                    Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                    DataFlowInfo dataFlowInfo = this.$context.dataFlowInfo;
                    Intrinsics.checkExpressionValueIsNotNull((Object)dataFlowInfo, (String)"context.dataFlowInfo");
                    return dataFlowInfo;
                }
                {
                    this.$context = basicCallResolutionContext;
                    super(1);
                }
            };
        }
        Call call2 = context2.call;
        Intrinsics.checkExpressionValueIsNotNull((Object)call2, (String)"context.call");
        Iterator<? extends ValueArgument> iterator2 = call2.getValueArguments().iterator();
        while (iterator2.hasNext()) {
            ValueArgument valueArgument;
            ValueArgument valueArgument2 = valueArgument = iterator2.next();
            if (valueArgument2 == null) {
                Intrinsics.throwNpe();
            }
            ArgumentMapping argumentMapping = (ArgumentMapping)getArgumentMapping.invoke((Object)valueArgument2);
            KotlinType expectedType = null;
            CallPosition callPosition = null;
            ValueParameterDescriptor parameter = null;
            ArgumentMapping argumentMapping2 = argumentMapping;
            if (argumentMapping2 instanceof ArgumentMatch) {
                expectedType = CallResolverUtilKt.getEffectiveExpectedType(((ArgumentMatch)argumentMapping).getValueParameter(), valueArgument, context2);
                ResolvedCall resolvedCall4 = results.getResultingCall();
                Intrinsics.checkExpressionValueIsNotNull((Object)resolvedCall4, (String)"results.resultingCall");
                callPosition = new CallPosition.ValueArgumentPosition(resolvedCall4, ((ArgumentMatch)argumentMapping).getValueParameter(), valueArgument);
                parameter = ((ArgumentMatch)argumentMapping).getValueParameter();
            } else {
                SimpleType simpleType2 = TypeUtils.NO_EXPECTED_TYPE;
                Intrinsics.checkExpressionValueIsNotNull((Object)simpleType2, (String)"TypeUtils.NO_EXPECTED_TYPE");
                expectedType = simpleType2;
                callPosition = CallPosition.Unknown.INSTANCE;
                parameter = null;
            }
            Object Context2 = ((BasicCallResolutionContext)((BasicCallResolutionContext)context2.replaceDataFlowInfo((DataFlowInfo)getDataFlowInfoForArgument.invoke((Object)valueArgument))).replaceExpectedType(expectedType)).replaceCallPosition(callPosition);
            Intrinsics.checkExpressionValueIsNotNull(Context2, (String)"context.replaceDataFlowI\u2026allPosition(callPosition)");
            BasicCallResolutionContext newContext = (BasicCallResolutionContext)Context2;
            this.completeOneArgument(valueArgument, parameter, newContext);
        }
    }

    private final SimpleType createTypeForConvertableConstant(CompileTimeConstant<?> constant) {
        SimpleType simpleType2 = TypeUtils.NO_EXPECTED_TYPE;
        Intrinsics.checkExpressionValueIsNotNull((Object)simpleType2, (String)"TypeUtils.NO_EXPECTED_TYPE");
        Object $this$safeAs$iv = constant.getValue(simpleType2);
        boolean $i$f$safeAs = false;
        Object obj = $this$safeAs$iv;
        if (!(obj instanceof Number)) {
            obj = null;
        }
        Number number = (Number)obj;
        if (number == null) {
            return null;
        }
        long value2 = number.longValue();
        IntegerValueTypeConstructor typeConstructor2 = new IntegerValueTypeConstructor(value2, this.moduleDescriptor, constant.getParameters());
        Annotations annotations2 = Annotations.Companion.getEMPTY();
        TypeConstructor typeConstructor3 = typeConstructor2;
        List list2 = CollectionsKt.emptyList();
        MemberScope memberScope2 = ErrorUtils.createErrorScope("Scope for number value type (" + typeConstructor2 + ')', true);
        Intrinsics.checkExpressionValueIsNotNull((Object)memberScope2, (String)"ErrorUtils.createErrorSc\u2026$typeConstructor)\", true)");
        return KotlinTypeFactory.simpleTypeWithNonTrivialMemberScope(annotations2, typeConstructor3, list2, false, memberScope2);
    }

    private final void completeOneArgument(ValueArgument argument, ValueParameterDescriptor parameter, BasicCallResolutionContext context2) {
        boolean bl;
        KtExpression ktExpression;
        KotlinType kotlinType2;
        boolean convertedConst;
        KotlinType recordedType;
        if (argument.isExternal()) {
            return;
        }
        KtExpression ktExpression2 = argument.getArgumentExpression();
        if (ktExpression2 == null) {
            return;
        }
        KtExpression expression2 = ktExpression2;
        KtExpression ktExpression3 = KtPsiUtil.getLastElementDeparenthesized(expression2, context2.statementFilter);
        if (ktExpression3 == null) {
            return;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression3, (String)"KtPsiUtil.getLastElement\u2026tatementFilter) ?: return");
        KtExpression deparenthesized = ktExpression3;
        KotlinType updatedType = recordedType = context2.trace.getType(expression2);
        OverloadResolutionResultsImpl<?> results = this.completeCallForArgument(deparenthesized, context2);
        CompileTimeConstant constant = (CompileTimeConstant)context2.trace.get(BindingContext.COMPILE_TIME_VALUE, deparenthesized);
        boolean bl2 = convertedConst = constant instanceof IntegerValueTypeConstant && ((IntegerValueTypeConstant)constant).getConvertedFromSigned();
        if (results != null && results.isSingleResult()) {
            ResolvedCall resolvedCall2 = results.getResultingCall();
            Intrinsics.checkExpressionValueIsNotNull((Object)resolvedCall2, (String)"results.resultingCall");
            ResolvedCall resolvedCall3 = resolvedCall2;
            if (!convertedConst) {
                KotlinType kotlinType3;
                if (resolvedCall3.hasInferredReturnType()) {
                    Object d = resolvedCall3.getResultingDescriptor();
                    kotlinType3 = ResolvedCallUtilKt.makeNullableTypeIfSafeReceiver(resolvedCall3, d != null ? d.getReturnType() : null, context2);
                } else {
                    kotlinType3 = updatedType = null;
                }
            }
        }
        if (recordedType != null && !recordedType.getConstructor().isDenotable() && (kotlinType2 = this.argumentTypeResolver.updateResultArgumentTypeIfNotDenotable(context2, expression2)) == null) {
            kotlinType2 = updatedType = updatedType;
        }
        if (parameter != null && ImplicitIntegerCoercion.INSTANCE.isEnabledForParameter(parameter)) {
            SimpleType generalNumberType;
            CompileTimeConstant argumentCompileTimeValue = (CompileTimeConstant)context2.trace.get(BindingContext.COMPILE_TIME_VALUE, deparenthesized);
            if (argumentCompileTimeValue != null && argumentCompileTimeValue.getParameters().isConvertableConstVal() && (generalNumberType = this.createTypeForConvertableConstant(argumentCompileTimeValue)) != null) {
                updatedType = this.argumentTypeResolver.updateResultArgumentTypeIfNotDenotable(context2.trace, context2.statementFilter, context2.expectedType, generalNumberType, expression2);
            }
        } else if (convertedConst) {
            context2.trace.report(Errors.SIGNED_CONSTANT_CONVERTED_TO_UNSIGNED.on((KtExpression)((PsiElement)deparenthesized)));
        }
        StatementFilter statementFilter = context2.statementFilter;
        Intrinsics.checkExpressionValueIsNotNull((Object)statementFilter, (String)"context.statementFilter");
        BindingTrace bindingTrace = context2.trace;
        Intrinsics.checkExpressionValueIsNotNull((Object)bindingTrace, (String)"context.trace");
        updatedType = this.updateRecordedTypeForArgument(updatedType, recordedType, expression2, statementFilter, bindingTrace);
        KtFunction ktFunction = ArgumentTypeResolver.getFunctionLiteralArgumentIfAny(expression2, context2);
        if (ktFunction != null) {
            ktExpression = ktFunction;
            boolean bl3 = false;
            bl = false;
            KtFunction functionLiteralArgument = ktExpression;
            boolean bl4 = false;
            this.argumentTypeResolver.getFunctionLiteralTypeInfo(expression2, functionLiteralArgument, context2, ResolveArgumentsMode.RESOLVE_FUNCTION_ARGUMENTS, false);
        }
        KtCallableReferenceExpression ktCallableReferenceExpression = ArgumentTypeResolver.getCallableReferenceExpressionIfAny(expression2, context2);
        if (ktCallableReferenceExpression != null) {
            ktExpression = ktCallableReferenceExpression;
            boolean bl5 = false;
            bl = false;
            KtExpression callableReferenceArgument = ktExpression;
            boolean bl6 = false;
            this.argumentTypeResolver.getCallableReferenceTypeInfo(expression2, (KtCallableReferenceExpression)callableReferenceArgument, context2, ResolveArgumentsMode.RESOLVE_FUNCTION_ARGUMENTS);
        }
        this.dataFlowAnalyzer.checkType(updatedType, deparenthesized, (ResolutionContext)context2);
    }

    /*
     * WARNING - void declaration
     */
    private final OverloadResolutionResultsImpl<?> completeCallForArgument(KtExpression expression2, BasicCallResolutionContext context2) {
        void cachedResolutionResults;
        void cachedContext;
        ResolutionResultsCache.CachedData cachedData;
        ResolutionResultsCache.CachedData cachedData2 = GenericCandidateResolverKt.getResolutionResultsCachedData(expression2, context2);
        if (cachedData2 == null) {
            return null;
        }
        ResolutionResultsCache.CachedData cachedData3 = cachedData = cachedData2;
        OverloadResolutionResultsImpl<?> overloadResolutionResultsImpl = cachedData3.component1();
        BasicCallResolutionContext basicCallResolutionContext = cachedData3.component2();
        TracingStrategy tracing = cachedData3.component3();
        Object Context2 = ((BasicCallResolutionContext)((BasicCallResolutionContext)((BasicCallResolutionContext)cachedContext.replaceBindingTrace(context2.trace)).replaceExpectedType(context2.expectedType)).replaceCollectAllCandidates(false)).replaceCallPosition(context2.callPosition);
        Intrinsics.checkExpressionValueIsNotNull(Context2, (String)"cachedContext.replaceBin\u2026ion(context.callPosition)");
        BasicCallResolutionContext contextForArgument = (BasicCallResolutionContext)Context2;
        return this.completeCall(contextForArgument, (OverloadResolutionResultsImpl)cachedResolutionResults, tracing);
    }

    private final KotlinType updateRecordedTypeForArgument(KotlinType updatedType, KotlinType recordedType, KtExpression argumentExpression, StatementFilter statementFilter, BindingTrace trace) {
        if (!ErrorUtils.containsErrorType(recordedType) && Intrinsics.areEqual((Object)recordedType, (Object)updatedType) || updatedType == null) {
            return updatedType;
        }
        Function1<KtExpression, KtExpression> $fun$deparenthesizeOrGetSelector$1 = new Function1<KtExpression, KtExpression>(statementFilter){
            final /* synthetic */ StatementFilter $statementFilter;

            @Nullable
            public final KtExpression invoke(@Nullable KtExpression expression2) {
                KtExpression deparenthesized = KtPsiUtil.deparenthesizeOnce(expression2);
                if (Intrinsics.areEqual((Object)deparenthesized, (Object)expression2) ^ true) {
                    return deparenthesized;
                }
                if (expression2 instanceof KtBlockExpression) {
                    return StatementFilterKt.getLastStatementInABlock(this.$statementFilter, (KtBlockExpression)expression2);
                }
                KtExpression ktExpression = expression2;
                if (!(ktExpression instanceof KtQualifiedExpression)) {
                    ktExpression = null;
                }
                KtQualifiedExpression ktQualifiedExpression = (KtQualifiedExpression)ktExpression;
                return ktQualifiedExpression != null ? ktQualifiedExpression.getSelectorExpression() : null;
            }
            {
                this.$statementFilter = statementFilter;
                super(1);
            }
        };
        ArrayList<KtExpression> expressions = new ArrayList<KtExpression>();
        KtExpression expression2 = argumentExpression;
        while (expression2 != null) {
            expressions.add(expression2);
            expression2 = $fun$deparenthesizeOrGetSelector$1.invoke(expression2);
        }
        boolean shouldBeMadeNullable = false;
        Iterable $this$forEach$iv = CollectionsKt.asReversedMutable((List)expressions);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            KtExpression ktExpression = (KtExpression)element$iv;
            boolean bl = false;
            if (!(ktExpression instanceof KtParenthesizedExpression || ktExpression instanceof KtLabeledExpression || ktExpression instanceof KtAnnotatedExpression)) {
                shouldBeMadeNullable = this.hasNecessarySafeCall(ktExpression, trace);
            }
            BindingContextUtils.updateRecordedType(updatedType, ktExpression, trace, shouldBeMadeNullable);
        }
        return trace.getType(argumentExpression);
    }

    private final boolean hasNecessarySafeCall(KtExpression expression2, BindingTrace trace) {
        if (!(expression2 instanceof KtSafeQualifiedExpression)) {
            return false;
        }
        KotlinType expressionType = trace.getType(((KtSafeQualifiedExpression)expression2).getReceiverExpression());
        return expressionType != null && TypeUtils.isNullableType(expressionType);
    }

    private final void updateResultDataFlowInfoUsingEffects(@NotNull MutableResolvedCall<?> $this$updateResultDataFlowInfoUsingEffects, BindingTrace bindingTrace) {
        if ($this$updateResultDataFlowInfoUsingEffects.getDataFlowInfoForArguments() instanceof MutableDataFlowInfoForArguments.WithoutArgumentsCheck) {
            return;
        }
        Object d = $this$updateResultDataFlowInfoUsingEffects.getResultingDescriptor();
        if (d == null || (d = d.getContainingDeclaration()) == null) {
            return;
        }
        ModuleDescriptor moduleDescriptor = DescriptorUtils.getContainingModule(d);
        Intrinsics.checkExpressionValueIsNotNull((Object)moduleDescriptor, (String)"DescriptorUtils.getConta\u2026ingDeclaration ?: return)");
        ModuleDescriptor moduleDescriptor2 = moduleDescriptor;
        DataFlowInfo resultDFIfromES = this.effectSystem.getDataFlowInfoForFinishedCall((ResolvedCall)$this$updateResultDataFlowInfoUsingEffects, bindingTrace, moduleDescriptor2);
        $this$updateResultDataFlowInfoUsingEffects.getDataFlowInfoForArguments().updateResultInfo(resultDFIfromES);
        this.effectSystem.recordDefiniteInvocations((ResolvedCall)$this$updateResultDataFlowInfoUsingEffects, bindingTrace, moduleDescriptor2);
    }

    public CallCompleter(@NotNull ArgumentTypeResolver argumentTypeResolver, @NotNull CandidateResolver candidateResolver, @NotNull DataFlowAnalyzer dataFlowAnalyzer, @NotNull Iterable<? extends CallChecker> callCheckers, @NotNull ModuleDescriptor moduleDescriptor, @NotNull DeprecationResolver deprecationResolver, @NotNull EffectSystem effectSystem, @NotNull DataFlowValueFactory dataFlowValueFactory) {
        Intrinsics.checkParameterIsNotNull((Object)argumentTypeResolver, (String)"argumentTypeResolver");
        Intrinsics.checkParameterIsNotNull((Object)candidateResolver, (String)"candidateResolver");
        Intrinsics.checkParameterIsNotNull((Object)dataFlowAnalyzer, (String)"dataFlowAnalyzer");
        Intrinsics.checkParameterIsNotNull(callCheckers, (String)"callCheckers");
        Intrinsics.checkParameterIsNotNull((Object)moduleDescriptor, (String)"moduleDescriptor");
        Intrinsics.checkParameterIsNotNull((Object)deprecationResolver, (String)"deprecationResolver");
        Intrinsics.checkParameterIsNotNull((Object)effectSystem, (String)"effectSystem");
        Intrinsics.checkParameterIsNotNull((Object)dataFlowValueFactory, (String)"dataFlowValueFactory");
        this.argumentTypeResolver = argumentTypeResolver;
        this.candidateResolver = candidateResolver;
        this.dataFlowAnalyzer = dataFlowAnalyzer;
        this.callCheckers = callCheckers;
        this.moduleDescriptor = moduleDescriptor;
        this.deprecationResolver = deprecationResolver;
        this.effectSystem = effectSystem;
        this.dataFlowValueFactory = dataFlowValueFactory;
    }

    public static final /* synthetic */ ModuleDescriptor access$getModuleDescriptor$p(CallCompleter $this) {
        return $this.moduleDescriptor;
    }
}

