/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.constants.evaluate;

import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.KtNodeTypes;
import org.jetbrains.kotlin.com.intellij.psi.tree.IElementType;
import org.jetbrains.kotlin.com.intellij.util.text.LiteralFormatUtil;
import org.jetbrains.kotlin.resolve.constants.evaluate.ParseUtilsKt;
import org.jetbrains.kotlin.utils.NumberWithRadix;
import org.jetbrains.kotlin.utils.NumbersKt;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=2, d1={"\u00004\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u0004\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u000e\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u000e\u0010\u0005\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u000e\u0010\u0006\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u0017\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u00a2\u0006\u0002\u0010\t\u001a\u0017\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u00a2\u0006\u0002\u0010\f\u001a\u0012\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a\u0017\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u00a2\u0006\u0002\u0010\u0011\u001a\u0018\u0010\u0012\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\u0014\u00a8\u0006\u0015"}, d2={"hasLongSuffix", "", "text", "", "hasUnsignedLongSuffix", "hasUnsignedSuffix", "parseBoolean", "parseDouble", "", "(Ljava/lang/String;)Ljava/lang/Double;", "parseFloat", "", "(Ljava/lang/String;)Ljava/lang/Float;", "parseFloatingLiteral", "", "parseLong", "", "(Ljava/lang/String;)Ljava/lang/Long;", "parseNumericLiteral", "type", "Lorg/jetbrains/kotlin/com/intellij/psi/tree/IElementType;", "frontend.common"})
public final class ParseUtilsKt {
    public static final boolean hasLongSuffix(@NotNull String text2) {
        Intrinsics.checkParameterIsNotNull((Object)text2, (String)"text");
        return StringsKt.endsWith$default((CharSequence)text2, (char)'l', (boolean)false, (int)2, null) || StringsKt.endsWith$default((CharSequence)text2, (char)'L', (boolean)false, (int)2, null);
    }

    public static final boolean hasUnsignedSuffix(@NotNull String text2) {
        Intrinsics.checkParameterIsNotNull((Object)text2, (String)"text");
        return StringsKt.endsWith$default((CharSequence)text2, (char)'u', (boolean)false, (int)2, null) || StringsKt.endsWith$default((CharSequence)text2, (char)'U', (boolean)false, (int)2, null);
    }

    public static final boolean hasUnsignedLongSuffix(@NotNull String text2) {
        Intrinsics.checkParameterIsNotNull((Object)text2, (String)"text");
        return StringsKt.endsWith$default((String)text2, (String)"ul", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)text2, (String)"uL", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)text2, (String)"Ul", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)text2, (String)"UL", (boolean)false, (int)2, null);
    }

    @Nullable
    public static final Number parseNumericLiteral(@NotNull String text2, @NotNull IElementType type2) {
        Intrinsics.checkParameterIsNotNull((Object)text2, (String)"text");
        Intrinsics.checkParameterIsNotNull((Object)type2, (String)"type");
        String string2 = LiteralFormatUtil.removeUnderscores(text2);
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"LiteralFormatUtil.removeUnderscores(text)");
        String canonicalText = string2;
        IElementType iElementType = type2;
        return Intrinsics.areEqual((Object)iElementType, (Object)KtNodeTypes.INTEGER_CONSTANT) ? (Number)ParseUtilsKt.parseLong(canonicalText) : (Number)(Intrinsics.areEqual((Object)iElementType, (Object)KtNodeTypes.FLOAT_CONSTANT) ? ParseUtilsKt.parseFloatingLiteral(canonicalText) : null);
    }

    /*
     * WARNING - void declaration
     */
    private static final Long parseLong(String text2) {
        Long l;
        parseLong.1 $fun$removeSuffix$1 = parseLong.1.INSTANCE;
        try {
            void number;
            boolean isUnsigned = false;
            String numberWithoutSuffix = null;
            if (ParseUtilsKt.hasUnsignedLongSuffix(text2)) {
                isUnsigned = true;
                numberWithoutSuffix = $fun$removeSuffix$1.invoke(text2, 2);
            } else if (ParseUtilsKt.hasUnsignedSuffix(text2)) {
                isUnsigned = true;
                numberWithoutSuffix = $fun$removeSuffix$1.invoke(text2, 1);
            } else if (ParseUtilsKt.hasLongSuffix(text2)) {
                isUnsigned = false;
                numberWithoutSuffix = $fun$removeSuffix$1.invoke(text2, 1);
            } else {
                isUnsigned = false;
                numberWithoutSuffix = text2;
            }
            NumberWithRadix numberWithRadix = NumbersKt.extractRadix(numberWithoutSuffix);
            String string2 = numberWithRadix.component1();
            int radix = numberWithRadix.component2();
            l = isUnsigned ? Long.parseUnsignedLong((String)number, radix) : Long.parseLong((String)number, radix);
        }
        catch (NumberFormatException e) {
            l = null;
        }
        return l;
    }

    private static final Number parseFloatingLiteral(String text2) {
        String string2 = text2;
        boolean bl = false;
        String string3 = string2;
        if (string3 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string4 = string3.toLowerCase();
        Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"(this as java.lang.String).toLowerCase()");
        if (StringsKt.endsWith$default((CharSequence)string4, (char)'f', (boolean)false, (int)2, null)) {
            return ParseUtilsKt.parseFloat(text2);
        }
        return ParseUtilsKt.parseDouble(text2);
    }

    private static final Double parseDouble(String text2) {
        try {
            return Double.parseDouble(text2);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    private static final Float parseFloat(String text2) {
        try {
            return Float.valueOf(Float.parseFloat(text2));
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public static final boolean parseBoolean(@NotNull String text2) {
        Intrinsics.checkParameterIsNotNull((Object)text2, (String)"text");
        if ("true".equals(text2)) {
            return true;
        }
        if ("false".equals(text2)) {
            return false;
        }
        throw (Throwable)new IllegalStateException("Must not happen. A boolean literal has text: " + text2);
    }
}

