"use strict";
/*
 * Copyright (C) 2017 TypeFox and others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at http://www.apache.org/licenses/LICENSE-2.0
 */
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : new P(function (resolve) { resolve(result.value); }).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
const goStatus_1 = require("../src/goStatus");
const goInstall_1 = require("../src/goInstall");
const commands_1 = require("./commands");
const goImport_1 = require("../src/goImport");
const goMain_1 = require("../src/goMain");
const window_1 = require("./window");
const goLint_1 = require("../src/goLint");
const goVet_1 = require("../src/goVet");
const goGenerateTests = require("../src/goGenerateTests");
const goGetPackage_1 = require("../src/goGetPackage");
const goModifytags_1 = require("../src/goModifytags");
const goPlayground_1 = require("../src/goPlayground");
const config_1 = require("./config");
const goBuild_1 = require("../src/goBuild");
const vscode_1 = require("./vscode");
const goInstallTools_1 = require("../src/goInstallTools");
const util_1 = require("../src/util");
function activate(lspClient, lspServer, logger) {
    return __awaiter(this, void 0, void 0, function* () {
        goStatus_1.outputChannel.lspClient = lspClient;
        window_1.window.lspClient = lspClient;
        console.log = logger.log.bind(logger);
        console.error = logger.error.bind(logger);
        console.warn = logger.warn.bind(logger);
        console.info = logger.info.bind(logger);
        goMain_1.errorDiagnosticCollection.onSet(lspClient.publishDiagnostics.bind(lspClient));
        goMain_1.warningDiagnosticCollection.onSet(lspClient.publishDiagnostics.bind(lspClient));
        commands_1.commands.lspClient = lspClient;
        commands_1.commands.registerCommand('go.gopath', () => {
            let gopath = util_1.getCurrentGoPath();
            let wasInfered = vscode_1.workspace.getConfiguration('go', window_1.window.activeTextEditor ? window_1.window.activeTextEditor.document.uri : null)['inferGopath'];
            let root = vscode_1.workspace.rootPath;
            if (window_1.window.activeTextEditor && vscode_1.workspace.getWorkspaceFolder(window_1.window.activeTextEditor.document.uri)) {
                root = vscode_1.workspace.getWorkspaceFolder(window_1.window.activeTextEditor.document.uri).uri.fsPath;
            }
            // not only if it was configured, but if it was successful.
            if (wasInfered && root && root.indexOf(gopath) === 0) {
                const inferredFrom = window_1.window.activeTextEditor ? 'current folder' : 'workspace root';
                window_1.window.showInformationMessage(`Current GOPATH is inferred from ${inferredFrom}: ${gopath}`);
            }
            else {
                window_1.window.showInformationMessage('Current GOPATH: ' + gopath);
            }
            if (util_1.getToolsGopath()) {
                window_1.window.showInformationMessage('toolsGopath: ' + util_1.getToolsGopath());
            }
        });
        commands_1.commands.registerCommand('go.import.add', (arg) => {
            return goImport_1.addImport(typeof arg === 'string' ? arg : null);
        });
        commands_1.commands.registerCommand('go.install.package', goInstall_1.installCurrentPackage);
        commands_1.commands.registerCommand('go.lint.package', goLint_1.lintCode);
        commands_1.commands.registerCommand('go.lint.workspace', () => goLint_1.lintCode(true));
        commands_1.commands.registerCommand('go.vet.package', goVet_1.vetCode);
        commands_1.commands.registerCommand('go.vet.workspace', () => goVet_1.vetCode(true));
        commands_1.commands.registerCommand('go.test.generate.package', () => {
            goGenerateTests.generateTestCurrentPackage();
        });
        commands_1.commands.registerCommand('go.test.generate.file', () => {
            goGenerateTests.generateTestCurrentFile();
        });
        commands_1.commands.registerCommand('go.test.generate.function', () => {
            goGenerateTests.generateTestCurrentFunction();
        });
        // unmapped:
        // 'go.toggle.test.file': missing command 'open.file'
        commands_1.commands.registerCommand('go.get.package', goGetPackage_1.goGetPackage);
        commands_1.commands.registerCommand('go.add.tags', (args) => {
            goModifytags_1.addTags(args);
        });
        commands_1.commands.registerCommand('go.remove.tags', (args) => {
            goModifytags_1.removeTags(args);
        });
        commands_1.commands.registerCommand('go.playground', goPlayground_1.playgroundCommand);
        commands_1.commands.registerCommand('go.show.commands', () => {
            const commandTitles = [];
            const title2commandId = new Map();
            for (let key of commands_1.commands.commandMap.keys()) {
                const title = config_1.CommandConfig.instance.getTitle(key);
                if (title) {
                    title2commandId.set(title, key);
                    commandTitles.push(title);
                }
            }
            window_1.window.showQuickPick(commandTitles).then(pick => {
                const command = title2commandId.get(pick);
                commands_1.commands.executeCommand(command);
            });
        });
        commands_1.commands.registerCommand('go.build.package', goBuild_1.buildCode);
        commands_1.commands.registerCommand('go.build.workspace', () => goBuild_1.buildCode(true));
        commands_1.commands.registerCommand('workbench.action.openGlobalSettings', () => {
            lspClient.logMessage({
                message: 'workbench.action.openGlobalSettings is called',
                type: vscode_1.MessageType.Warning
            });
        });
        commands_1.commands.registerCommand('workbench.action.openWorkspaceSettings', () => {
            lspClient.logMessage({
                message: 'workbench.action.openWorkspaceSettings is called',
                type: vscode_1.MessageType.Warning
            });
        });
        commands_1.commands.registerCommand('go.tools.install', goInstallTools_1.installAllTools);
        return goInstallTools_1.updateGoPathGoRootFromConfig().then(() => {
            lspClient.sendTelemetryEvent(vscode_1.workspace.getConfiguration('go'));
            goInstallTools_1.offerToInstallTools();
        });
    });
}
exports.activate = activate;
function mockActivate(lspClient) {
    window_1.window.lspClient = lspClient;
    commands_1.commands.lspClient = lspClient;
    goMain_1.errorDiagnosticCollection.onSet(lspClient.publishDiagnostics.bind(lspClient));
    goMain_1.warningDiagnosticCollection.onSet(lspClient.publishDiagnostics.bind(lspClient));
}
exports.mockActivate = mockActivate;
//# sourceMappingURL=activate.js.map