#!/usr/bin/env node
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const commander_1 = require("commander");
const lsp_connection_1 = require("./lsp-connection");
const lsp = require("vscode-languageserver");
const program = new commander_1.Command('go-language-server')
    .version(require('../../package.json').version)
    .option('--stdio', 'use stdio')
    .option('--node-ipc', 'use node-ipc')
    .option('--log-level <logLevel>', 'A number indicating the log level (4 = log, 3 = info, 2 = warn, 1 = error). Defaults to `2`.')
    .option('--socket <port>', 'use socket. example: --socket=5000')
    .parse(process.argv);
if (!(program.stdio || program.socket || program['node-ipc'])) {
    console.error('Connection type required (stdio, node-ipc, socket). Refer to --help for more details.');
    process.exit(1);
}
let logLevel = lsp.MessageType.Warning;
if (program.logLevel) {
    logLevel = parseInt(program.logLevel, 10);
    if (logLevel && (logLevel < 1 || logLevel > 4)) {
        console.error('Invalid `--log-level ' + logLevel + '`. Falling back to `info` level.');
        logLevel = lsp.MessageType.Warning;
    }
}
lsp_connection_1.createLspConnection({
    goServerPath: program.goServerPath,
    goServerLogFile: program.goServerLogFile,
    goServerLogVerbosity: program.goServerLogVerbosity,
    showMessageLevel: logLevel
}).listen();
//# sourceMappingURL=cli.js.map