"use strict";
/*
 * Copyright (C) 2017 TypeFox and others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at http://www.apache.org/licenses/LICENSE-2.0
 */
Object.defineProperty(exports, "__esModule", { value: true });
const lsp = require("vscode-languageserver");
const uuid_1 = require("vscode-languageserver/lib/utils/uuid");
class CommandRegistry {
    constructor() {
        this.commandMap = new Map();
    }
    executeCommand(command, ...rest) {
        const func = this.commandMap.get(command);
        if (func)
            return func.apply(null, rest);
        else
            this.lspClient.logMessage({
                message: 'No such command \'' + command + '\'',
                type: lsp.MessageType.Error
            });
    }
    registerCommand(command, callback) {
        this.commandMap.set(command, callback);
        const registrationParams = {
            registrations: [
                {
                    id: uuid_1.generateUuid(),
                    method: 'workspace/executeCommand',
                    registerOptions: {
                        commands: [command]
                    }
                }
            ]
        };
        this.lspClient.registerCapability(registrationParams);
        // TODO implement deregistration
    }
}
exports.CommandRegistry = CommandRegistry;
exports.commands = new CommandRegistry();
//# sourceMappingURL=commands.js.map