"use strict";
/*
 * Copyright (C) 2017 TypeFox and others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at http://www.apache.org/licenses/LICENSE-2.0
 */
Object.defineProperty(exports, "__esModule", { value: true });
const fs_extra_1 = require("fs-extra");
require('pkginfo')(module);
class FileBasedConfig {
    constructor(path) {
        try {
            const data = fs_extra_1.readFileSync(path, 'UTF-8');
            const elements = JSON.parse(data);
            for (let key in elements) {
                this[key] = elements[key];
            }
        }
        catch (err) {
            console.log(err);
            // file read error
        }
    }
}
exports.FileBasedConfig = FileBasedConfig;
class DefaultConfig {
    constructor() {
        const config = module.exports.contributes.configuration.properties;
        for (let k in config) {
            const key = k.replace(/^go\./, '');
            this[key] = config[k].default;
        }
        this['enableCodeLens'] = {
            runtest: false,
            references: true
        };
        this['formatFlags'] = '';
    }
    get(key) {
        return this[key];
    }
}
DefaultConfig.instance = new DefaultConfig();
exports.DefaultConfig = DefaultConfig;
class CommandConfig {
    constructor() {
        this.map = new Map();
        const commands = module.exports.contributes.commands;
        for (let command of commands) {
            this.map.set(command.command, command.title);
        }
    }
    getTitle(commandId) {
        return this.map.get(commandId);
    }
}
CommandConfig.instance = new CommandConfig();
exports.CommandConfig = CommandConfig;
//# sourceMappingURL=config.js.map