"use strict";
/*
 * Copyright (C) 2017 TypeFox and others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at http://www.apache.org/licenses/LICENSE-2.0
 */
Object.defineProperty(exports, "__esModule", { value: true });
const utils_1 = require("./utils");
const vscode_jsonrpc_1 = require("vscode-jsonrpc");
class Diagnostic {
    constructor(range, message, severity) {
        this.range = range;
        this.message = message;
        this.severity = severity;
    }
}
exports.Diagnostic = Diagnostic;
class DiagnosticCollection {
    constructor(name) {
        this.name = name;
        this.store = new Map();
        this.onSetEmitter = new vscode_jsonrpc_1.Emitter();
        this.onSet = this.onSetEmitter.event;
    }
    clear() {
        this.store.forEach((value, uri) => {
            this.onSetEmitter.fire({
                diagnostics: [],
                uri: utils_1.uriToStringUri(uri)
            });
        });
        this.store.clear();
    }
    set(uri, diagnostics) {
        this.store.set(uri, diagnostics);
        this.onSetEmitter.fire({
            diagnostics: diagnostics,
            uri: utils_1.uriToStringUri(uri)
        });
    }
    get(uri) {
        return this.store.get(uri);
    }
}
exports.DiagnosticCollection = DiagnosticCollection;
//# sourceMappingURL=diagnostics.js.map