"use strict";
/*
 * Copyright (C) 2017 TypeFox and others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at http://www.apache.org/licenses/LICENSE-2.0
 */
Object.defineProperty(exports, "__esModule", { value: true });
const diagnostics_1 = require("./diagnostics");
const mock_error_1 = require("./mock-error");
var languages;
(function (languages) {
    languages.registerCodeActionsProvider = mock_error_1.mockFunction;
    languages.registerCodeLensProvider = mock_error_1.mockFunction;
    languages.registerCompletionItemProvider = mock_error_1.mockFunction;
    languages.registerDefinitionProvider = mock_error_1.mockFunction;
    languages.registerDocumentFormattingEditProvider = mock_error_1.mockFunction;
    languages.registerDocumentSymbolProvider = mock_error_1.mockFunction;
    languages.registerHoverProvider = mock_error_1.mockFunction;
    languages.registerImplementationProvider = mock_error_1.mockFunction;
    languages.registerReferenceProvider = mock_error_1.mockFunction;
    languages.registerRenameProvider = mock_error_1.mockFunction;
    languages.registerSignatureHelpProvider = mock_error_1.mockFunction;
    languages.registerWorkspaceSymbolProvider = mock_error_1.mockFunction;
    languages.setLanguageConfiguration = mock_error_1.mockFunction;
    function createDiagnosticCollection(name) {
        return new diagnostics_1.DiagnosticCollection(name);
    }
    languages.createDiagnosticCollection = createDiagnosticCollection;
    function match(filter, document) {
        return true;
    }
    languages.match = match;
})(languages = exports.languages || (exports.languages = {}));
//# sourceMappingURL=languages.js.map