"use strict";
/*
 * Copyright (C) 2017 TypeFox and others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at http://www.apache.org/licenses/LICENSE-2.0
 */
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : new P(function (resolve) { resolve(result.value); }).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
const lsp = require("vscode-languageserver");
class LspClientImpl {
    constructor(connection) {
        this.connection = connection;
    }
    publishDiagnostics(args) {
        this.connection.sendNotification(lsp.PublishDiagnosticsNotification.type, args);
    }
    showMessage(args) {
        this.connection.sendNotification(lsp.ShowMessageNotification.type, args);
    }
    logMessage(args) {
        this.connection.sendNotification(lsp.LogMessageNotification.type, args);
    }
    sendTelemetryEvent(args) {
        this.connection.sendNotification(lsp.TelemetryEventNotification.type, args);
    }
    showMessageRequest(args) {
        return __awaiter(this, void 0, void 0, function* () {
            return this.connection.sendRequest(lsp.ShowMessageRequest.type, args);
        });
    }
    applyWorkspaceEdit(args) {
        return __awaiter(this, void 0, void 0, function* () {
            return this.connection.sendRequest(lsp.ApplyWorkspaceEditRequest.type, args);
        });
    }
    showInformationMessage(msg, ...options) {
        return __awaiter(this, void 0, void 0, function* () {
            if (!options) {
                this.showMessageRequest({
                    message: msg,
                    type: 3
                });
                return undefined;
            }
            else {
                const selected = yield this.showMessageRequest({
                    message: msg,
                    type: 3,
                    actions: options.map(title => { return { title }; })
                });
                if (selected)
                    return selected.title;
                else
                    return undefined;
            }
        });
    }
    registerCapability(args) {
        return __awaiter(this, void 0, void 0, function* () {
            return this.connection.sendRequest(lsp.RegistrationRequest.type, args);
        });
    }
}
exports.LspClientImpl = LspClientImpl;
//# sourceMappingURL=lsp-client.js.map