"use strict";
/*
 * Copyright (C) 2017 TypeFox and others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at http://www.apache.org/licenses/LICENSE-2.0
 */
Object.defineProperty(exports, "__esModule", { value: true });
const fs_1 = require("fs");
const path = require("path");
const types_1 = require("./types");
const lsp = require("vscode-languageserver");
class SnippetProposalProvider {
    constructor(logger) {
        this.proposals = [];
        const snippetPath = path.resolve(__dirname, '..', '..', 'snippets', 'go.json');
        try {
            const data = fs_1.readFileSync(snippetPath, 'UTF-8');
            const snippets = JSON.parse(data)['.source.go'];
            for (let description in snippets) {
                const snippet = snippets[description];
                const item = new types_1.CompletionItem(snippet.prefix, lsp.CompletionItemKind.Snippet);
                item.insertText = snippet.body;
                item.insertTextFormat = lsp.InsertTextFormat.Snippet;
                item.detail = description;
                item.sortText = 'b';
                this.proposals.push(item);
            }
        }
        catch (err) {
            logger.error(this, 'Error reading snippets', err);
        }
    }
}
exports.SnippetProposalProvider = SnippetProposalProvider;
//# sourceMappingURL=snippet-proposal-provider.js.map