"use strict";
/*
 * Copyright (C) 2017 TypeFox and others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at http://www.apache.org/licenses/LICENSE-2.0
 */
Object.defineProperty(exports, "__esModule", { value: true });
const path = require("path");
const fs = require("fs");
const utils_1 = require("./utils");
function uri(suffix) {
    const resolved = this.testFilePath(suffix);
    return utils_1.pathToUri(resolved);
}
exports.uri = uri;
function testWorkspacePath() {
    return path.resolve(__dirname, '..', '..', 'test-lsp');
}
exports.testWorkspacePath = testWorkspacePath;
function testFilePath(suffix) {
    return path.resolve(testWorkspacePath(), suffix);
}
exports.testFilePath = testFilePath;
function writeContents(path, contents) {
    fs.writeFileSync(path, contents, 'utf-8');
}
exports.writeContents = writeContents;
function readContents(path) {
    return fs.readFileSync(path, 'utf-8').toString();
}
exports.readContents = readContents;
//# sourceMappingURL=test-utils.js.map