"use strict";
/*
 * Copyright (C) 2017 TypeFox and others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at http://www.apache.org/licenses/LICENSE-2.0
 */
Object.defineProperty(exports, "__esModule", { value: true });
const types_1 = require("./types");
const lsp = require("vscode-languageserver");
const vscode_languageserver_1 = require("vscode-languageserver");
class TextEditor {
    constructor(document, lspClient) {
        this.document = document;
        this.lspClient = lspClient;
        this.selection = new types_1.Selection(new types_1.Range(0, 0, 0, 0));
    }
    edit(editBuilder) {
        const textEditorEdit = new TextEditorEdit();
        editBuilder.call(null, textEditorEdit);
        const workspaceEdit = new types_1.WorkspaceEdit();
        workspaceEdit.set(this.document.uri, textEditorEdit.textEdits);
        this.lspClient.applyWorkspaceEdit({ edit: workspaceEdit });
    }
}
exports.TextEditor = TextEditor;
class TextEditorEdit {
    constructor() {
        this.textEdits = [];
    }
    replace(location /*| Selection*/, newText) {
        if (lsp.Position.is(location))
            this.textEdits.push(vscode_languageserver_1.TextEdit.replace(new types_1.Range(location, location), newText));
        else
            this.textEdits.push(vscode_languageserver_1.TextEdit.replace(location, newText));
    }
    insert(location, newText) {
        this.textEdits.push(vscode_languageserver_1.TextEdit.insert(location, newText));
    }
    delete(location /*| Selection*/) {
        this.textEdits.push(vscode_languageserver_1.TextEdit.del(location));
    }
}
exports.TextEditorEdit = TextEditorEdit;
//# sourceMappingURL=text-editor.js.map