"use strict";
/*
 * Copyright (C) 2017 TypeFox and others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at http://www.apache.org/licenses/LICENSE-2.0
 */
Object.defineProperty(exports, "__esModule", { value: true });
const utils_1 = require("./utils");
const window_1 = require("./window");
const lsp = require("vscode-languageserver");
class CodeLens {
    constructor(range, command) {
        this.range = range;
        this.command = command;
    }
}
exports.CodeLens = CodeLens;
class CompletionItem {
    constructor(label, kind) {
        this.label = label;
        this.kind = kind;
    }
}
exports.CompletionItem = CompletionItem;
class ExtensionContext {
    constructor() {
        this.subscriptions = [];
    }
}
exports.ExtensionContext = ExtensionContext;
class FormattingOptions {
}
exports.FormattingOptions = FormattingOptions;
class GlobalState {
    get(key, defaultValue) {
        return undefined;
    }
    update(key, value) {
        return undefined;
    }
}
exports.GlobalState = GlobalState;
class Hover {
    constructor(contents, range) {
        this.contents = contents;
        this.range = range;
    }
}
exports.Hover = Hover;
var InsertTextFormat;
(function (InsertTextFormat) {
    InsertTextFormat.PlainText = 1;
    InsertTextFormat.Snippet = 2;
})(InsertTextFormat = exports.InsertTextFormat || (exports.InsertTextFormat = {}));
class Location {
    constructor(rangeOrUri, uriRangeOrPosition) {
        this.rangeOrUri = rangeOrUri;
        this.uriRangeOrPosition = uriRangeOrPosition;
        if (lsp.Range.is(rangeOrUri))
            this.range = rangeOrUri;
        else
            this.uri = utils_1.uriToStringUri(rangeOrUri);
        if (lsp.Range.is(uriRangeOrPosition))
            this.range = uriRangeOrPosition;
        else if (lsp.Position.is(uriRangeOrPosition))
            this.range = new Range(uriRangeOrPosition, uriRangeOrPosition);
        else
            this.uri = uriRangeOrPosition;
    }
}
exports.Location = Location;
class ParameterInformation {
    constructor(label, documentation) {
        this.label = label;
        this.documentation = documentation;
    }
}
exports.ParameterInformation = ParameterInformation;
class Position {
    constructor(line, character) {
        this.line = line;
        this.character = character;
    }
}
exports.Position = Position;
class Range {
    constructor(first, second, endLine = -1, endCharacter = -1) {
        if (lsp.Range.is(first)) {
            this.start = first.start;
            this.end = first.end;
        }
        else if (lsp.Position.is(first) && lsp.Position.is(second)) {
            this.start = first;
            this.end = second;
        }
        else {
            this.start = new Position(first, second);
            this.end = new Position(endLine, endCharacter);
        }
    }
    static contains(range, position) {
        return (range.start.line < position.line
            || (range.start.line === position.line && range.start.character <= position.character))
            && (range.end.line > position.line
                || (range.end.line === position.line && range.end.character >= position.character));
    }
    isEmpty() {
        return this.start.line === this.end.line
            && this.start.character === this.end.character;
    }
}
exports.Range = Range;
class Selection extends Range {
    constructor(range) {
        super(range);
    }
    get active() {
        return this.start;
    }
}
exports.Selection = Selection;
class SignatureHelp {
}
exports.SignatureHelp = SignatureHelp;
class SignatureInformation {
    constructor(label, documentation /* | MarkdownString*/) {
        this.label = label;
        this.documentation = documentation; /* | MarkdownString*/
        this.parameters = [];
    }
}
exports.SignatureInformation = SignatureInformation;
class StatusBarItem {
    constructor(alignment, priority) {
        this.alignment = alignment;
        this.priority = priority;
    }
    show() { }
    ;
    hide() { }
    ;
    dispose() { }
    ;
}
exports.StatusBarItem = StatusBarItem;
var StatusBarAlignment;
(function (StatusBarAlignment) {
    StatusBarAlignment[StatusBarAlignment["Left"] = 1] = "Left";
    StatusBarAlignment[StatusBarAlignment["Right"] = 2] = "Right";
})(StatusBarAlignment = exports.StatusBarAlignment || (exports.StatusBarAlignment = {}));
class SymbolInformation {
    constructor(name, kind, range, uri, containerName) {
        this.name = name;
        this.kind = kind;
        this.range = range;
        this.containerName = containerName;
        if (uri)
            this.location = new Location(range, utils_1.uriToStringUri(uri));
        else
            this.location = new Location(range, utils_1.uriToStringUri(window_1.window.activeTextEditor.document.uri));
    }
}
exports.SymbolInformation = SymbolInformation;
class TextEdit {
    constructor(range, newText) {
        this.range = range;
        this.newText = newText;
    }
    static insert(position, text) {
        return new TextEdit(new Range(position, position), text);
    }
    static delete(range) {
        return new TextEdit(range, '');
    }
    static replace(range, text) {
        return new TextEdit(range, text);
    }
}
exports.TextEdit = TextEdit;
class WorkspaceEdit {
    constructor() {
        this.changes = {};
    }
    set(uri, edits) {
        this.changes[utils_1.uriToStringUri(uri)] = edits;
    }
    add(uri, edit) {
        const existing = this.changes[utils_1.uriToStringUri(uri)];
        if (existing)
            existing.push(edit);
        else
            this.set(uri, [edit]);
    }
    insert(uri, position, text) {
        this.add(uri, new TextEdit(new Range(position, position), text));
    }
    delete(uri, range) {
        this.add(uri, new TextEdit(range, ''));
    }
    replace(uri, range, text) {
        this.add(uri, new TextEdit(range, text));
    }
}
exports.WorkspaceEdit = WorkspaceEdit;
//# sourceMappingURL=types.js.map