"use strict";
/*
 * Copyright (C) 2017 TypeFox and others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at http://www.apache.org/licenses/LICENSE-2.0
 */
Object.defineProperty(exports, "__esModule", { value: true });
const vscode_uri_1 = require("vscode-uri");
class Deferred {
    constructor(operation, timeout) {
        this.operation = operation;
        this.promise = new Promise((resolve, reject) => {
            this.resolve = resolve;
            this.reject = reject;
        });
        setTimeout(() => {
            this.reject(new Error(this.operation + ' timeout'));
        }, timeout || 20000);
    }
}
exports.Deferred = Deferred;
function getTsserverExecutable() {
    return isWindows() ? 'tsserver.cmd' : 'tsserver';
}
exports.getTsserverExecutable = getTsserverExecutable;
function isWindows() {
    return /^win/.test(process.platform);
}
exports.isWindows = isWindows;
function uriToPath(stringUri) {
    const uri = vscode_uri_1.default.parse(stringUri);
    return uri.fsPath;
}
exports.uriToPath = uriToPath;
function pathToUri(p) {
    return 'file://' + (isWindows() ? '/' + p.replace(/\//g, '/') : p);
}
exports.pathToUri = pathToUri;
function uriToStringUri(uri) {
    return pathToUri(uri.fsPath);
}
exports.uriToStringUri = uriToStringUri;
//# sourceMappingURL=utils.js.map