"use strict";
/*
 * Copyright (C) 2017 TypeFox and others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at http://www.apache.org/licenses/LICENSE-2.0
 */
Object.defineProperty(exports, "__esModule", { value: true });
const types_1 = require("./types");
const lsp = require("vscode-languageserver");
class Window {
    constructor() {
        this.visibleTextEditors = [];
    }
    createOutputChannel(name) {
        return new OutputChannel(name);
    }
    createStatusBarItem(alignment, priority) {
        return new types_1.StatusBarItem(alignment, priority);
    }
    showInformationMessage(message, ...items) {
        if (items) {
            const choices = items.map(item => typeof item === 'string' ? item : item.title);
            return this.lspClient.showInformationMessage(message, ...choices).then(selection => {
                return items.find(item => item === selection || item.title === selection);
            });
        }
        else {
            return this.lspClient.showInformationMessage(message).then(result => undefined);
        }
    }
    showQuickPick(items /*| Thenable<string[]>/*, options?: QuickPickOptions, token?: CancellationToken*/) {
        return this.lspClient.showInformationMessage('', ...items).then(selection => {
            return items.find(item => item === selection);
        });
    }
    showErrorMessage(message) {
        this.lspClient.showMessage({
            message: message,
            type: lsp.MessageType.Error
        });
    }
}
exports.window = new Window();
class OutputChannel {
    constructor(name) {
        this.name = name;
    }
    append(value) {
        if (this.lspClient) {
            this.lspClient.logMessage({
                message: value,
                type: lsp.MessageType.Info
            });
        }
    }
    appendLine(value) {
        this.append(value);
    }
    clear() {
        // TODO: implement
    }
    show(preserveFocus) {
        // TODO: implement
    }
    hide() {
        // TODO: implement
    }
    dispose() {
        // TODO: implement
    }
}
exports.OutputChannel = OutputChannel;
//# sourceMappingURL=window.js.map