"use strict";
/*
 * Copyright (C) 2017 TypeFox and others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at http://www.apache.org/licenses/LICENSE-2.0
 */
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : new P(function (resolve) { resolve(result.value); }).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
const utils_1 = require("./utils");
const config_1 = require("./config");
const os = require("os");
const path = require("path");
class WorkspaceConfiguration {
    constructor(defaultValues, globalValues, workspaceValues, workspaceFolderValues) {
        this.defaultValues = defaultValues;
        this.globalValues = globalValues;
        this.workspaceValues = workspaceValues;
        this.workspaceFolderValues = workspaceFolderValues;
        const mergedValues = Object.assign({}, defaultValues, globalValues, workspaceValues, workspaceFolderValues);
        for (let key in mergedValues)
            this[key] = mergedValues[key];
    }
    get(section) {
        return this[section];
    }
    inspect(section) {
        const value = this.get(section);
        if (value) {
            return {
                key: section,
                defaultValue: this.defaultValues.get(section),
                globalValue: this.globalValues.get(section),
                workspaceValue: this.workspaceValues.get(section),
                workspaceFolderValue: this.workspaceFolderValues.get(section)
            };
        }
    }
}
exports.WorkspaceConfiguration = WorkspaceConfiguration;
class WorkspacConfigurationProvider {
    constructor() {
        this.defaultConfig = config_1.DefaultConfig.instance;
        this.folder2config = new Map();
        this.path2config = new Map();
    }
    get(section, uri) {
        const workspaceFolder = this.getWorkspaceFolder(uri);
        if (workspaceFolder) {
            const config = this.folder2config.get(workspaceFolder);
            if (config)
                return config;
            const workspaceConfiguration = new WorkspaceConfiguration(this.defaultConfig, this.getConfig(path.join(os.homedir(), '.go')), this.getConfig(exports.workspace.rootPath), this.getConfig(workspaceFolder.uri.fsPath));
            this.folder2config.set(workspaceFolder, workspaceConfiguration);
            return workspaceConfiguration;
        }
        return new WorkspaceConfiguration(this.defaultConfig, this.getConfig(path.join(os.homedir(), '.go')), this.getConfig(exports.workspace.rootPath), {});
    }
    getWorkspaceFolder(uri) {
        if (uri)
            return exports.workspace.getWorkspaceFolder(uri);
        else if (exports.workspace.workspaceFolders.length === 1)
            return exports.workspace.workspaceFolders[0];
        else
            return undefined;
    }
    isConfigFile(uri) {
        return this.path2config.get(uri.fsPath) !== undefined;
    }
    getConfig(folder) {
        if (!folder)
            return {};
        const configPath = path.join(folder, 'go.json');
        const cached = this.path2config.get(configPath);
        if (!cached) {
            const config = new config_1.FileBasedConfig(configPath);
            this.path2config.set(configPath, config);
            return config;
        }
        else {
            return cached;
        }
    }
}
exports.WorkspacConfigurationProvider = WorkspacConfigurationProvider;
class WorkspaceFolder {
    constructor(uri) {
        this.uri = uri;
    }
}
exports.WorkspaceFolder = WorkspaceFolder;
class Workspace {
    constructor() {
        this.workspaceConfigurationProvider = new WorkspacConfigurationProvider();
        this.workspaceFolders = [];
    }
    getConfiguration(section, resource) {
        return this.workspaceConfigurationProvider.get(section, resource);
    }
    getWorkspaceFolder(uri) {
        const filePath = utils_1.uriToStringUri(uri);
        return this.workspaceFolders.find(f => {
            const rawPath = utils_1.uriToStringUri(f.uri);
            const path = (rawPath.endsWith('/')) ? rawPath : rawPath + '/';
            if (filePath.startsWith(path) || filePath === rawPath) {
                return true;
            }
        });
    }
    applyEdit(edit) {
        this.lspClient.applyWorkspaceEdit({ edit: edit });
    }
    saveAll(includeUntitled) {
        return __awaiter(this, void 0, void 0, function* () {
            return true;
        });
    }
}
exports.workspace = new Workspace();
//# sourceMappingURL=workspace.js.map