import { ChildProcess } from 'child_process';
import { Message } from './messages';
import { Event } from './events';
export interface DataCallback {
    (data: Message): void;
}
export interface PartialMessageInfo {
    messageToken: number;
    waitingTime: number;
}
export interface MessageReader {
    onError: Event<Error>;
    onClose: Event<void>;
    onPartialMessage: Event<PartialMessageInfo>;
    listen(callback: DataCallback): void;
}
export declare abstract class AbstractMessageReader {
    private errorEmitter;
    private closeEmitter;
    private partialMessageEmitter;
    constructor();
    onError: Event<Error>;
    protected fireError(error: any): void;
    onClose: Event<void>;
    protected fireClose(): void;
    onPartialMessage: Event<PartialMessageInfo>;
    protected firePartialMessage(info: PartialMessageInfo): void;
    private asError(error);
}
export declare class StreamMessageReader extends AbstractMessageReader implements MessageReader {
    private readable;
    private callback;
    private buffer;
    private nextMessageLength;
    private messageToken;
    private partialMessageTimer;
    private _partialMessageTimeout;
    constructor(readable: NodeJS.ReadableStream, encoding?: string);
    partialMessageTimeout: number;
    listen(callback: DataCallback): void;
    private onData(data);
    private clearPartialMessageTimer();
    private setPartialMessageTimer();
}
export declare class IPCMessageReader extends AbstractMessageReader implements MessageReader {
    private process;
    constructor(process: NodeJS.Process | ChildProcess);
    listen(callback: DataCallback): void;
}
