#!/bin/bash
# set -e

usage() {
  echo "Usage:"
  echo "$0 [-f <manifest filename with path>][-p <project directory>]"
  echo "Set environment variables THREESCALE_USER_KEY and THREESCALE_API_URL"
  exit -1
}

while getopts ":f:p:" o; do
  case "${o}" in
    f)
      f=${OPTARG}
      ;;
    p)
      p=${OPTARG}
      ;;
    *)
      usage
      ;;
  esac
done

if [ -z "${f}" ] || [ -z "${p}" ]; then
  usage
  exit -1
fi

export THREESCALE_API_URL=https://friendly_system_service-2445582075730.production.gw.apicast.io:443/api/v1/stack-analyses/
export THREESCALE_USER_KEY=250f7573417ff52aee50728f698ecd96

echo "Analyzing your application stack ..."

manifest=$(basename $f)
if [ "$manifest" == "pom.xml" ]
then
  mkdir -p ${p}/target
  rm -rf ${p}/target/*
  echo "Generating effective POM.."
  mvn help:effective-pom -f "$f" -Doutput="${p}/target/pom.xml"
  manifest="${p}/target/pom.xml"
else
  manifest=$f
fi

manifest='@'$manifest
api_url=$THREESCALE_API_URL
output=`curl -s -X POST -F "manifest[]=$manifest" -F"filePath[]=$p"  $api_url?user_key=$THREESCALE_USER_KEY`
id=`echo $output|python -c "import sys, json; print(json.load(sys.stdin)['id'])"`
echo "Analyzing project dependencies..."
echo "Waiting for API response..."
get_cmd="$api_url/$id?user_key=$THREESCALE_USER_KEY"
FINISHED=$(curl -s $get_cmd | grep finished_at)
OUT=$?
starttime=$(date +%s)
while [ ! $OUT -eq 0 ] && [ $(( $(date +%s) - 30 )) -lt $starttime ];
do
  FINISHED=$(curl -s $get_cmd | grep finished_at)
  OUT=$?
  sleep 1
done
curl -s $get_cmd > /tmp/analytics.json
python ${HOME}/report.py
