"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.publishVSIX = exports.listFiles = exports.publish = exports.createVSIX = exports.PackageManager = void 0;
const publish_1 = require("./publish");
const package_1 = require("./package");
/**
 * The supported list of package managers.
 */
var PackageManager;
(function (PackageManager) {
    PackageManager[PackageManager["Npm"] = 0] = "Npm";
    PackageManager[PackageManager["Yarn"] = 1] = "Yarn";
})(PackageManager = exports.PackageManager || (exports.PackageManager = {}));
/**
 * Creates a VSIX from the extension in the current working directory.
 */
function createVSIX(options = {}) {
    return package_1.packageCommand(options);
}
exports.createVSIX = createVSIX;
/**
 * Publishes the extension in the current working directory.
 */
function publish(options = {}) {
    return publish_1.publish(options);
}
exports.publish = publish;
/**
 * Lists the files included in the extension's package.
 */
function listFiles(options = {}) {
    return package_1.listFiles(options.cwd, options.packageManager === PackageManager.Yarn, options.packagedDependencies, options.ignoreFile);
}
exports.listFiles = listFiles;
/**
 * Publishes a pre-build VSIX.
 */
function publishVSIX(packagePath, options = {}) {
    return publish_1.publish(Object.assign({ packagePath }, options));
}
exports.publishVSIX = publishVSIX;
