"use strict";
/**********************************************************************
 * Copyright (c) 2018-2020 Red Hat, Inc.
 *
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 ***********************************************************************/
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.InitSources = void 0;
var axios = require("axios");
var fs = require("fs-extra");
var jsYaml = require("js-yaml");
var os = require("os");
var path = require("path");
var readPkg = require("read-pkg");
var tmp = require("tmp");
var cli_error_1 = require("./cli-error");
var logger_1 = require("./logger");
var repository_1 = require("./repository");
/**
 * Init all sources of extensions and plugins by cloning them, creating symlinks, update package.json, etc.
 * @author Florent Benoit
 */
var InitSources = /** @class */ (function () {
    /**
     * Constructor
     */
    function InitSources(rootFolder, packagesFolder, pluginsFolder, cheTheiaFolder, assemblyFolder, theiaVersion) {
        this.rootFolder = rootFolder;
        this.packagesFolder = packagesFolder;
        this.pluginsFolder = pluginsFolder;
        this.cheTheiaFolder = cheTheiaFolder;
        this.assemblyFolder = assemblyFolder;
        this.theiaVersion = theiaVersion;
        /**
         * Source clone locations could be replaced from the command line --alias option.
         */
        this.sourceLocationAliases = new Map();
        /**
         * Set of global dependencies
         */
        this.globalDevDependencies = new Map();
        /**
         * Will clone sources keeping or omiting the history
         */
        this.keepHistory = true;
        this.extensions = [];
    }
    Object.defineProperty(InitSources.prototype, "keepGitHistory", {
        /**
         * Keep or omit git history when cloning sources
         */
        set: function (value) {
            this.keepHistory = value;
        },
        enumerable: false,
        configurable: true
    });
    /**
     * Install all extensions
     */
    InitSources.prototype.generate = function (extensionsPath, isDevMode) {
        if (isDevMode === void 0) { isDevMode = false; }
        return __awaiter(this, void 0, void 0, function () {
            var extensionsYamlContent, extensionsYaml;
            var _this = this;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0: return [4 /*yield*/, fs.readFile(extensionsPath)];
                    case 1:
                        extensionsYamlContent = _a.sent();
                        extensionsYaml = jsYaml.load(extensionsYamlContent.toString());
                        return [4 /*yield*/, this.initGlobalDependencies()];
                    case 2:
                        _a.sent();
                        return [4 /*yield*/, fs.ensureDir(this.cheTheiaFolder)];
                    case 3:
                        _a.sent();
                        return [4 /*yield*/, Promise.all(extensionsYaml.sources.map(function (extension) { return __awaiter(_this, void 0, void 0, function () {
                                return __generator(this, function (_a) {
                                    switch (_a.label) {
                                        case 0:
                                            if (isDevMode) {
                                                extension.checkoutTo = 'main';
                                            }
                                            return [4 /*yield*/, this.addExtension(extension)];
                                        case 1:
                                            _a.sent();
                                            this.extensions.push(extension);
                                            return [2 /*return*/];
                                    }
                                });
                            }); }))];
                    case 4:
                        _a.sent();
                        return [4 /*yield*/, this.initRootCompilationUnits()];
                    case 5:
                        _a.sent();
                        return [2 /*return*/];
                }
            });
        });
    };
    /**
     * Update configs/root-compilation.tsconfig.json
     */
    InitSources.prototype.initRootCompilationUnits = function () {
        return __awaiter(this, void 0, void 0, function () {
            var rootCompilationUnitPath, rawData, parsed, item, assemblyTsConfig, json;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        rootCompilationUnitPath = path.join(this.rootFolder, 'configs/root-compilation.tsconfig.json');
                        return [4 /*yield*/, fs.readFile(rootCompilationUnitPath)];
                    case 1:
                        rawData = _a.sent();
                        parsed = JSON.parse(rawData.toString());
                        item = {
                            path: '../examples/assembly/compile.tsconfig.json',
                        };
                        assemblyTsConfig = parsed['references'].find(function (reference) { return reference['path'] === item['path']; });
                        if (!assemblyTsConfig) {
                            parsed['references'].push(item);
                        }
                        json = JSON.stringify(parsed, undefined, 2);
                        return [4 /*yield*/, fs.writeFile(rootCompilationUnitPath, json + "\n")];
                    case 2:
                        _a.sent();
                        return [2 /*return*/];
                }
            });
        });
    };
    /**
     * Scan package.json file and grab all dev dependencies and store them in globalDevDependencies variable
     */
    InitSources.prototype.initGlobalDependencies = function () {
        return __awaiter(this, void 0, void 0, function () {
            var extensionPackage, keys;
            var _this = this;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0: return [4 /*yield*/, readPkg(path.join(this.rootFolder, 'package.json'), { normalize: false })];
                    case 1:
                        extensionPackage = _a.sent();
                        keys = Object.keys(extensionPackage.devDependencies);
                        return [4 /*yield*/, Promise.all(keys.map(function (key) {
                                _this.globalDevDependencies.set(key, extensionPackage.devDependencies[key]);
                            }))];
                    case 2:
                        _a.sent();
                        return [2 /*return*/];
                }
            });
        });
    };
    /**
     * Adds an extension to the current theia
     * @param extension the extension to add
     */
    InitSources.prototype.addExtension = function (extension) {
        return __awaiter(this, void 0, void 0, function () {
            var sourceAlias;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        sourceAlias = this.sourceLocationAliases.get(extension.source);
                        if (sourceAlias) {
                            logger_1.Logger.info("Source alias detected for " + extension.source + ", replacing with provided source: " + sourceAlias);
                            extension.source = sourceAlias;
                        }
                        // first, clone
                        return [4 /*yield*/, this.clone(extension)];
                    case 1:
                        // first, clone
                        _a.sent();
                        // perform symlink
                        return [4 /*yield*/, this.symlink(extension)];
                    case 2:
                        // perform symlink
                        _a.sent();
                        return [4 /*yield*/, this.updateDependencies(extension)];
                    case 3:
                        _a.sent();
                        // insert extensions
                        return [4 /*yield*/, this.insertExtensionIntoAssembly(extension)];
                    case 4:
                        // insert extensions
                        _a.sent();
                        // perform plugins
                        return [4 /*yield*/, this.pluginsSymlink(extension)];
                    case 5:
                        // perform plugins
                        _a.sent();
                        return [2 /*return*/];
                }
            });
        });
    };
    /**
     * perform update of devDependencies or dependencies in package.json file of the cloned extension
     */
    InitSources.prototype.updateDependencies = function (extension, rewrite) {
        if (rewrite === void 0) { rewrite = true; }
        return __awaiter(this, void 0, void 0, function () {
            var _this = this;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0: return [4 /*yield*/, Promise.all(extension.extSymbolicLinks.map(function (symbolicLink) { return __awaiter(_this, void 0, void 0, function () {
                            var extensionJsonPath, extensionPackage, rawExtensionPackage, dependencies, devDependencies, updatedDependencies, updatedDevDependencies, keysDependencies, keysDevDependencies, json;
                            var _this = this;
                            return __generator(this, function (_a) {
                                switch (_a.label) {
                                    case 0:
                                        extensionJsonPath = path.join(symbolicLink, 'package.json');
                                        return [4 /*yield*/, readPkg(extensionJsonPath, { normalize: false })];
                                    case 1:
                                        extensionPackage = _a.sent();
                                        rawExtensionPackage = require(extensionJsonPath);
                                        dependencies = extensionPackage.dependencies;
                                        devDependencies = extensionPackage.devDependencies;
                                        updatedDependencies = {};
                                        updatedDevDependencies = {};
                                        keysDependencies = dependencies ? Object.keys(dependencies) : [];
                                        return [4 /*yield*/, Promise.all(keysDependencies.map(function (key) { return __awaiter(_this, void 0, void 0, function () {
                                                return __generator(this, function (_a) {
                                                    updatedDependencies[key] = this.updateDependency(key, dependencies[key]);
                                                    return [2 /*return*/];
                                                });
                                            }); }))];
                                    case 2:
                                        _a.sent();
                                        rawExtensionPackage['dependencies'] = updatedDependencies;
                                        keysDevDependencies = devDependencies ? Object.keys(devDependencies) : [];
                                        return [4 /*yield*/, Promise.all(keysDevDependencies.map(function (key) { return __awaiter(_this, void 0, void 0, function () {
                                                return __generator(this, function (_a) {
                                                    updatedDevDependencies[key] = this.updateDependency(key, devDependencies[key]);
                                                    return [2 /*return*/];
                                                });
                                            }); }))];
                                    case 3:
                                        _a.sent();
                                        rawExtensionPackage['devDependencies'] = updatedDevDependencies;
                                        if (!rewrite) return [3 /*break*/, 5];
                                        json = JSON.stringify(rawExtensionPackage, undefined, 2);
                                        return [4 /*yield*/, fs.writeFile(extensionJsonPath, json + os.EOL, { encoding: 'utf-8' })];
                                    case 4:
                                        _a.sent();
                                        _a.label = 5;
                                    case 5: return [2 /*return*/];
                                }
                            });
                        }); }))];
                    case 1:
                        _a.sent();
                        return [2 /*return*/];
                }
            });
        });
    };
    /**
     * Update the given dependency by comparing with global dependencies or checking if it's a theia dependency.
     * @param dependencyKey the key of dependency
     * @param dependencyValue its original value
     */
    InitSources.prototype.updateDependency = function (dependencyKey, dependencyValue) {
        // is it already defined as a Theia dev dependency ? if yes then return this value
        var rest = this.globalDevDependencies.get(dependencyKey);
        if (rest) {
            return rest;
        }
        // is it a theia dependency
        if (dependencyKey.startsWith('@theia/')) {
            // add carret and the current version
            return "^" + this.theiaVersion;
        }
        // return default value
        return dependencyValue;
    };
    /**
     * Insert the given extension into the package.json of the assembly.
     * @param extension the given extension
     */
    InitSources.prototype.insertExtensionIntoAssembly = function (extension) {
        return __awaiter(this, void 0, void 0, function () {
            var assemblyPackageJsonPath, assemblyJsonRawContent, dependencies, json;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        assemblyPackageJsonPath = path.join(this.assemblyFolder, 'package.json');
                        assemblyJsonRawContent = require(assemblyPackageJsonPath);
                        dependencies = assemblyJsonRawContent.dependencies;
                        extension.extSymbolicLinks.forEach(function (extensionSymLink) {
                            // first resolve path
                            var resolvedPath = path.resolve(extensionSymLink, 'package.json');
                            // read extension name within symlink
                            var extensionName = require(resolvedPath).name;
                            var extensionVersion = require(resolvedPath).version;
                            dependencies[extensionName] = extensionVersion;
                        });
                        json = JSON.stringify(assemblyJsonRawContent, undefined, 2);
                        return [4 /*yield*/, fs.writeFile(assemblyPackageJsonPath, json)];
                    case 1:
                        _a.sent();
                        return [2 /*return*/];
                }
            });
        });
    };
    InitSources.prototype.symlink = function (source) {
        return __awaiter(this, void 0, void 0, function () {
            var symbolicLinks, dest;
            var _this = this;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        symbolicLinks = [];
                        if (!source.extensions) return [3 /*break*/, 2];
                        // ok here we have several folders, need to iterate
                        return [4 /*yield*/, Promise.all(source.extensions.map(function (folder) { return __awaiter(_this, void 0, void 0, function () {
                                var sourceFolder, dest;
                                return __generator(this, function (_a) {
                                    switch (_a.label) {
                                        case 0:
                                            sourceFolder = path.resolve(source.clonedDir, folder);
                                            dest = path.resolve(this.packagesFolder, "" + InitSources.PREFIX_PACKAGES_EXTENSIONS + path.basename(sourceFolder));
                                            logger_1.Logger.info("Creating symlink from " + sourceFolder + " to " + dest);
                                            return [4 /*yield*/, fs.ensureSymlink(sourceFolder, dest)];
                                        case 1:
                                            _a.sent();
                                            symbolicLinks.push(dest);
                                            return [2 /*return*/];
                                    }
                                });
                            }); }))];
                    case 1:
                        // ok here we have several folders, need to iterate
                        _a.sent();
                        return [3 /*break*/, 4];
                    case 2:
                        dest = path.resolve(this.packagesFolder, "" + InitSources.PREFIX_PACKAGES_EXTENSIONS + path.basename(source.clonedDir));
                        logger_1.Logger.info("Creating symlink from " + source.clonedDir + " to " + dest);
                        return [4 /*yield*/, fs.ensureSymlink(source.clonedDir, dest)];
                    case 3:
                        _a.sent();
                        symbolicLinks.push(dest);
                        _a.label = 4;
                    case 4:
                        source.extSymbolicLinks = symbolicLinks;
                        return [2 /*return*/];
                }
            });
        });
    };
    InitSources.prototype.pluginsSymlink = function (source) {
        return __awaiter(this, void 0, void 0, function () {
            var symbolicLinks, dest;
            var _this = this;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        symbolicLinks = [];
                        if (!source.plugins) return [3 /*break*/, 2];
                        // ok here we have several folders, need to iterate
                        return [4 /*yield*/, Promise.all(source.plugins.map(function (folder) { return __awaiter(_this, void 0, void 0, function () {
                                var sourceFolder, dest;
                                return __generator(this, function (_a) {
                                    switch (_a.label) {
                                        case 0:
                                            sourceFolder = path.resolve(source.clonedDir, folder);
                                            dest = path.resolve(this.pluginsFolder, "" + path.basename(sourceFolder));
                                            logger_1.Logger.info("Creating symlink from " + sourceFolder + " to " + dest);
                                            return [4 /*yield*/, fs.ensureSymlink(sourceFolder, dest)];
                                        case 1:
                                            _a.sent();
                                            symbolicLinks.push(dest);
                                            return [2 /*return*/];
                                    }
                                });
                            }); }))];
                    case 1:
                        // ok here we have several folders, need to iterate
                        _a.sent();
                        return [3 /*break*/, 4];
                    case 2:
                        dest = path.resolve(this.pluginsFolder, "" + path.basename(source.clonedDir));
                        logger_1.Logger.info("Creating symlink from " + source.clonedDir + " to " + dest);
                        return [4 /*yield*/, fs.ensureSymlink(source.clonedDir, dest)];
                    case 3:
                        _a.sent();
                        symbolicLinks.push(dest);
                        _a.label = 4;
                    case 4:
                        source.pluginSymbolicLinks = symbolicLinks;
                        return [2 /*return*/];
                }
            });
        });
    };
    /**
     * Clone the given extension with the correct branch/tag
     * @param extension the extension to clone
     */
    InitSources.prototype.clone = function (extension) {
        return __awaiter(this, void 0, void 0, function () {
            var repository, _a;
            return __generator(this, function (_b) {
                switch (_b.label) {
                    case 0:
                        if (!fs.existsSync(extension.source)) return [3 /*break*/, 1];
                        logger_1.Logger.info("Skipping cloning sources for " + extension.source + " already provided...");
                        extension.clonedDir = extension.source;
                        return [3 /*break*/, 3];
                    case 1:
                        logger_1.Logger.info("Cloning " + extension.source + "...");
                        repository = new repository_1.Repository(extension.source);
                        _a = extension;
                        return [4 /*yield*/, repository.clone(this.cheTheiaFolder, repository.getRepositoryName(), extension.checkoutTo, this.keepHistory)];
                    case 2:
                        _a.clonedDir = _b.sent();
                        _b.label = 3;
                    case 3: return [2 /*return*/];
                }
            });
        });
    };
    InitSources.prototype.initSourceLocationAliases = function (alias) {
        return __awaiter(this, void 0, void 0, function () {
            var _this = this;
            return __generator(this, function (_a) {
                if (alias) {
                    alias.forEach(function (element) {
                        if (element.indexOf('=')) {
                            var index = element.substring(0, element.indexOf('='));
                            var value = element.substring(element.indexOf('=') + 1, element.length);
                            _this.sourceLocationAliases.set(index, value);
                        }
                    });
                }
                return [2 /*return*/];
            });
        });
    };
    InitSources.prototype.readConfigurationAndGenerate = function (configPath, dev) {
        return __awaiter(this, void 0, void 0, function () {
            var extensionsYamlPath, tmpFile, response, data;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        if (!configPath) return [3 /*break*/, 1];
                        extensionsYamlPath = path.resolve(configPath);
                        if (!fs.existsSync(extensionsYamlPath)) {
                            throw new cli_error_1.CliError('Config file does not exists');
                        }
                        return [3 /*break*/, 3];
                    case 1:
                        logger_1.Logger.debug("Config wasn't provided, downloading default...");
                        tmpFile = tmp.fileSync();
                        return [4 /*yield*/, axios.default.get(InitSources.DEFAULT_EXTENSIONS_URI)];
                    case 2:
                        response = _a.sent();
                        data = response.data;
                        fs.writeFileSync(tmpFile.name, data);
                        extensionsYamlPath = tmpFile.name;
                        _a.label = 3;
                    case 3: return [4 /*yield*/, this.generate(extensionsYamlPath, dev)];
                    case 4:
                        _a.sent();
                        return [2 /*return*/];
                }
            });
        });
    };
    /**
     * Prefix for extensions.
     */
    InitSources.PREFIX_PACKAGES_EXTENSIONS = '@che-';
    InitSources.DEFAULT_EXTENSIONS_URI = 'https://raw.githubusercontent.com/eclipse-che/che-theia/main/che-theia-init-sources.yml';
    InitSources.argBuilder = function (theYargs) {
        return theYargs
            .option('config', {
            description: 'Path to custom config file',
            alias: 'c',
        })
            .option('dev', {
            description: 'Initialize current Theia with Che/Theia extensions from "main" branch instead of provided branches',
            alias: 'd',
            type: 'boolean',
            default: false,
        })
            .option('alias', {
            description: "Replace clone source location. If a local path is provided, it won't clone anything but use the folder as a source folder.",
            type: 'array',
        });
    };
    return InitSources;
}());
exports.InitSources = InitSources;
//# sourceMappingURL=init-sources.js.map