"use strict";
/**********************************************************************
 * Copyright (c) 2018-2020 Red Hat, Inc.
 *
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 ***********************************************************************/
var __values = (this && this.__values) || function(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.Clean = void 0;
var fs = require("fs-extra");
var path = require("path");
/**
 * Clean up Theia repository:
 * 1. Remove symbolic links in 'packages' folder
 * 2. Remove 'che' folder
 * 3. Remove 'assembly' folder
 * 4. Remove 'node_modules' folder
 */
var Clean = /** @class */ (function () {
    function Clean(assemblyFolder, cheFolder, packagesFolder, pluginsFolder, nodeModules) {
        this.assemblyFolder = assemblyFolder;
        this.cheFolder = cheFolder;
        this.packagesFolder = packagesFolder;
        this.pluginsFolder = pluginsFolder;
        this.nodeModules = nodeModules;
    }
    Clean.prototype.cleanCheTheia = function () {
        var e_1, _a, e_2, _b;
        console.log('Removing extension symbolic links...');
        var packages = fs.readdirSync(this.packagesFolder);
        try {
            for (var packages_1 = __values(packages), packages_1_1 = packages_1.next(); !packages_1_1.done; packages_1_1 = packages_1.next()) {
                var pack = packages_1_1.value;
                var extPath = path.resolve(this.packagesFolder, pack);
                var stat = fs.lstatSync(extPath);
                if (stat.isSymbolicLink()) {
                    fs.unlinkSync(extPath);
                }
            }
        }
        catch (e_1_1) { e_1 = { error: e_1_1 }; }
        finally {
            try {
                if (packages_1_1 && !packages_1_1.done && (_a = packages_1.return)) _a.call(packages_1);
            }
            finally { if (e_1) throw e_1.error; }
        }
        console.log('Removing plugin symbolic links...');
        var plugins = fs.readdirSync(this.pluginsFolder);
        try {
            for (var plugins_1 = __values(plugins), plugins_1_1 = plugins_1.next(); !plugins_1_1.done; plugins_1_1 = plugins_1.next()) {
                var plugin = plugins_1_1.value;
                var pluginPath = path.resolve(this.pluginsFolder, plugin);
                var stat = fs.lstatSync(pluginPath);
                if (stat.isSymbolicLink()) {
                    fs.unlinkSync(pluginPath);
                }
            }
        }
        catch (e_2_1) { e_2 = { error: e_2_1 }; }
        finally {
            try {
                if (plugins_1_1 && !plugins_1_1.done && (_b = plugins_1.return)) _b.call(plugins_1);
            }
            finally { if (e_2) throw e_2.error; }
        }
        console.log('Removing plugins folder...');
        fs.removeSync(this.pluginsFolder);
        console.log('Removing extensions...');
        fs.removeSync(this.cheFolder);
        console.log('Removing assembly...');
        fs.removeSync(this.assemblyFolder);
        // we also need to clean up node_modules
        console.log('Removing "node_modules"...');
        fs.removeSync(this.nodeModules);
    };
    return Clean;
}());
exports.Clean = Clean;
//# sourceMappingURL=clean.js.map