"use strict";
/**********************************************************************
 * Copyright (c) 2018-2021 Red Hat, Inc.
 *
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 ***********************************************************************/
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
var __values = (this && this.__values) || function(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.generateAssembly = exports.handleCommand = exports.builder = void 0;
var fs = require("fs-extra");
var mustache = require("mustache");
var path = require("path");
var init_1 = require("./init");
var logger_1 = require("./logger");
var yarn_1 = require("./yarn");
var json_utils_1 = require("./json-utils");
exports.builder = {
    'che-theia': {
        describe: 'Path of the che-theia project source',
        requiresArg: true,
        type: 'string',
        demandOption: false,
    },
    'theia-version': {
        describe: 'Theia version to set',
        requiresArg: true,
        type: 'string',
        demandOption: false,
        default: 'next',
    },
};
// eslint-disable-next-line @typescript-eslint/no-explicit-any
function handleCommand(args) {
    return __awaiter(this, void 0, void 0, function () {
        var cheTheiaDir, theiaVersion, monacoVersion, assemblyDir, extensionsDir, folderNames, extensions, folderNames_1, folderNames_1_1, folderName, pkgJson, theiaPlugins;
        var e_1, _a;
        return __generator(this, function (_b) {
            switch (_b.label) {
                case 0:
                    cheTheiaDir = args['che-theia '] || process.cwd();
                    theiaVersion = args['theia-version'];
                    return [4 /*yield*/, yarn_1.getFullPackageName(cheTheiaDir, init_1.Init.MONACO_CORE_PKG)];
                case 1:
                    monacoVersion = _b.sent();
                    if (!monacoVersion) {
                        throw new Error("Package not found: " + init_1.Init.MONACO_CORE_PKG);
                    }
                    assemblyDir = path.resolve(cheTheiaDir, 'assembly');
                    return [4 /*yield*/, generateAssembly(assemblyDir, {
                            theiaVersion: theiaVersion,
                            monacoVersion: monacoVersion,
                            configDirPrefix: '../../',
                            packageRefPrefix: '../extensions/',
                        })];
                case 2:
                    _b.sent();
                    extensionsDir = path.resolve(cheTheiaDir, 'extensions');
                    return [4 /*yield*/, fs.readdir(extensionsDir)];
                case 3:
                    folderNames = _b.sent();
                    extensions = new Map();
                    try {
                        for (folderNames_1 = __values(folderNames), folderNames_1_1 = folderNames_1.next(); !folderNames_1_1.done; folderNames_1_1 = folderNames_1.next()) {
                            folderName = folderNames_1_1.value;
                            pkgJson = require(path.resolve(extensionsDir, folderName, 'package.json'));
                            extensions.set(pkgJson.name, pkgJson.version);
                        }
                    }
                    catch (e_1_1) { e_1 = { error: e_1_1 }; }
                    finally {
                        try {
                            if (folderNames_1_1 && !folderNames_1_1.done && (_a = folderNames_1.return)) _a.call(folderNames_1);
                        }
                        finally { if (e_1) throw e_1.error; }
                    }
                    return [4 /*yield*/, fs.readJson(path.resolve(__dirname, '../src/templates/theiaPlugins.json'))];
                case 4:
                    theiaPlugins = _b.sent();
                    // eslint-disable-next-line @typescript-eslint/no-explicit-any
                    json_utils_1.rewriteJson(path.resolve(assemblyDir, 'package.json'), function (json) {
                        var deps = json.dependencies || {};
                        extensions.forEach(function (version, name) {
                            deps[name] = version;
                        });
                        json.dependencies = deps;
                        json.scripts['download:plugins'] = 'theia download:plugins';
                        json.scripts.prepare = json.scripts.prepare + ' && yarn download:plugins';
                        json.theiaPluginsDir = '../plugins';
                        json.theiaPlugins = theiaPlugins;
                    });
                    return [2 /*return*/];
            }
        });
    });
}
exports.handleCommand = handleCommand;
function generateAssembly(examplesAssemblyFolder, config) {
    return __awaiter(this, void 0, void 0, function () {
        var srcDir, distDir, templateDir, compileTsConfig, template, target;
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0:
                    srcDir = path.resolve(__dirname, '../src');
                    distDir = path.resolve(__dirname, '../dist');
                    templateDir = path.join(srcDir, 'templates');
                    compileTsConfig = path.join(templateDir, 'assembly-compile.tsconfig.mst.json');
                    // generate assembly if does not exists
                    return [4 /*yield*/, fs.ensureDir(examplesAssemblyFolder)];
                case 1:
                    // generate assembly if does not exists
                    _a.sent();
                    template = path.join(templateDir, 'assembly-package.mst.json');
                    target = path.join(examplesAssemblyFolder, 'package.json');
                    return [4 /*yield*/, renderTemplate(template, target, config)];
                case 2:
                    _a.sent();
                    return [4 /*yield*/, renderTemplate(compileTsConfig, path.join(examplesAssemblyFolder, 'compile.tsconfig.mst.json'), config)];
                case 3:
                    _a.sent();
                    logger_1.Logger.info("copying " + path.join(templateDir, 'cdn') + " to " + path.join(examplesAssemblyFolder, 'cdn'));
                    return [4 /*yield*/, fs.copy(path.join(templateDir, 'cdn'), path.join(examplesAssemblyFolder, 'cdn'))];
                case 4:
                    _a.sent();
                    logger_1.Logger.info('distdir=' + distDir);
                    return [4 /*yield*/, fs.copy(path.join(distDir, 'cdn'), path.join(examplesAssemblyFolder, 'cdn'))];
                case 5:
                    _a.sent();
                    return [4 /*yield*/, fs.copy(path.join(srcDir, 'scripts'), path.join(examplesAssemblyFolder, 'scripts'))];
                case 6:
                    _a.sent();
                    return [2 /*return*/];
            }
        });
    });
}
exports.generateAssembly = generateAssembly;
function renderTemplate(template, target, config) {
    return __awaiter(this, void 0, void 0, function () {
        var content, rendered;
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0: return [4 /*yield*/, fs.readFile(template)];
                case 1:
                    content = _a.sent();
                    rendered = mustache.render(content.toString(), config).replace(/&#x2F;/g, '/');
                    return [4 /*yield*/, fs.writeFile(target, rendered)];
                case 2:
                    _a.sent();
                    return [2 /*return*/];
            }
        });
    });
}
//# sourceMappingURL=generate-assembly.js.map