"use strict";
/**********************************************************************
 * Copyright (c) 2018-2020 Red Hat, Inc.
 *
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 ***********************************************************************/
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
var __spread = (this && this.__spread) || function () {
    for (var ar = [], i = 0; i < arguments.length; i++) ar = ar.concat(__read(arguments[i]));
    return ar;
};
var __values = (this && this.__values) || function(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.handleCommand = exports.builder = void 0;
/**
 * Simple code to rewrite versions of a dependency in package.json files
 * @author Thomas Mäder
 */
var glob = require("glob");
var path = require("path");
var util_1 = require("util");
var json_utils_1 = require("./json-utils");
exports.builder = {
    'theia-version': {
        describe: 'The version of Theia to uses in che-theia',
        requiresArg: true,
        type: 'string',
        demandOption: true,
    },
    'che-theia': {
        describe: 'Path of the che-theia project source',
        requiresArg: true,
        type: 'string',
        demandOption: false,
    },
};
var EXCLUSIONS = ['@theia/plugin-packager'];
// eslint-disable-next-line @typescript-eslint/no-explicit-any
function handleCommand(args) {
    return __awaiter(this, void 0, void 0, function () {
        var cheTheiaDir, theiaVersion, packageJsons, _a, _b, _c, packageJsons_1, packageJsons_1_1, packageJson, e_1_1;
        var e_1, _d;
        return __generator(this, function (_e) {
            switch (_e.label) {
                case 0:
                    cheTheiaDir = args['che-theia '] || process.cwd();
                    theiaVersion = args['theia-version'];
                    return [4 /*yield*/, util_1.promisify(glob)(cheTheiaDir + '/extensions/*/package.json')];
                case 1:
                    packageJsons = _e.sent();
                    _b = (_a = packageJsons.push).apply;
                    _c = [packageJsons];
                    return [4 /*yield*/, util_1.promisify(glob)(cheTheiaDir + '/plugins/*/package.json')];
                case 2:
                    _b.apply(_a, _c.concat([__spread.apply(void 0, [(_e.sent())])]));
                    packageJsons.push(path.resolve(cheTheiaDir, 'generator/package.json'));
                    packageJsons.push(path.resolve(cheTheiaDir, 'assembly/package.json'));
                    packageJsons.push(path.resolve(cheTheiaDir, 'package.json'));
                    _e.label = 3;
                case 3:
                    _e.trys.push([3, 8, 9, 10]);
                    packageJsons_1 = __values(packageJsons), packageJsons_1_1 = packageJsons_1.next();
                    _e.label = 4;
                case 4:
                    if (!!packageJsons_1_1.done) return [3 /*break*/, 7];
                    packageJson = packageJsons_1_1.value;
                    return [4 /*yield*/, updateDependencies(packageJson, function (packageName) {
                            if (packageName.startsWith('@theia') && !EXCLUSIONS.includes(packageName)) {
                                return theiaVersion;
                            }
                        })];
                case 5:
                    _e.sent();
                    _e.label = 6;
                case 6:
                    packageJsons_1_1 = packageJsons_1.next();
                    return [3 /*break*/, 4];
                case 7: return [3 /*break*/, 10];
                case 8:
                    e_1_1 = _e.sent();
                    e_1 = { error: e_1_1 };
                    return [3 /*break*/, 10];
                case 9:
                    try {
                        if (packageJsons_1_1 && !packageJsons_1_1.done && (_d = packageJsons_1.return)) _d.call(packageJsons_1);
                    }
                    finally { if (e_1) throw e_1.error; }
                    return [7 /*endfinally*/];
                case 10: return [2 /*return*/];
            }
        });
    });
}
exports.handleCommand = handleCommand;
function updateDependencies(packageJSONPath, replaceVersion) {
    return __awaiter(this, void 0, void 0, function () {
        var e_2;
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0:
                    _a.trys.push([0, 2, , 3]);
                    return [4 /*yield*/, json_utils_1.rewriteJson(packageJSONPath, function (pkgJson) {
                            // we're assuming the package.json is well formed
                            replaceInSection(pkgJson.dependencies, replaceVersion);
                            replaceInSection(pkgJson.devDependencies, replaceVersion);
                        })];
                case 1:
                    _a.sent();
                    return [3 /*break*/, 3];
                case 2:
                    e_2 = _a.sent();
                    console.warn('could not find package json: ' + packageJSONPath);
                    return [2 /*return*/];
                case 3: return [2 /*return*/];
            }
        });
    });
}
// eslint-disable-next-line @typescript-eslint/no-explicit-any
function replaceInSection(section, replaceVersion) {
    if (section) {
        for (var dep in section) {
            if (section.hasOwnProperty(dep)) {
                var replacement = replaceVersion(dep);
                if (replacement) {
                    section[dep] = replacement;
                }
            }
        }
    }
}
//# sourceMappingURL=update-dependencies.js.map