/**********************************************************************
 * Copyright (c) 2018-2020 Red Hat, Inc.
 *
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 ***********************************************************************/
import { ISource } from './init-sources';
/**
 * Generates the examples/assembly
 * @author Florent Benoit
 */
export declare class Init {
    readonly rootFolder: string;
    readonly examplesAssemblyFolder: string;
    readonly checkoutFolder: string;
    readonly pluginsFolder: string;
    static readonly GET_PACKAGE_WITH_VERSION_CMD = "yarn --json --non-interactive --no-progress list --pattern=";
    static readonly MONACO_CORE_PKG = "@theia/monaco-editor-core";
    constructor(rootFolder: string, examplesAssemblyFolder: string, checkoutFolder: string, pluginsFolder: string);
    getCurrentVersion(): Promise<string>;
    generate(): Promise<void>;
    updadeBuildConfiguration(extensions: ISource[]): Promise<void>;
    updatePluginsConfiguration(): Promise<void>;
    private static getPluginsList;
    getPackageWithVersion(name: string): Promise<string>;
}
//# sourceMappingURL=init.d.ts.map