"use strict";
/**********************************************************************
 * Copyright (c) 2018-2021 Red Hat, Inc.
 *
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 ***********************************************************************/
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
var __values = (this && this.__values) || function(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.link = exports.handleCommand = exports.builder = void 0;
/**
 * A command to yarn link theia dependencies into che-theia
 * @author Thomas Mäder
 */
var fs = require("fs-extra");
var os = require("os");
var path = require("path");
var command_1 = require("./command");
exports.builder = {
    theia: {
        describe: 'Path of the theia project source',
        requiresArg: true,
        type: 'string',
        demandOption: false,
    },
    'che-theia': {
        describe: 'Path of the che-theia project source',
        requiresArg: true,
        type: 'string',
        demandOption: false,
    },
};
// eslint-disable-next-line @typescript-eslint/no-explicit-any
function handleCommand(args) {
    return __awaiter(this, void 0, void 0, function () {
        var theiaDir, cheTheiaDir, cfg, yarnConfig, linkDir, e_1;
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0:
                    theiaDir = args.theia || path.resolve(process.cwd(), '../theia');
                    cheTheiaDir = args['che-theia'] || process.cwd();
                    return [4 /*yield*/, new command_1.Command(cheTheiaDir).exec('yarn --silent --json --non-interactive config current')];
                case 1:
                    cfg = _a.sent();
                    _a.label = 2;
                case 2:
                    _a.trys.push([2, 6, , 7]);
                    yarnConfig = JSON.parse(JSON.parse(cfg).data);
                    linkDir = yarnConfig['linkFolder'] || path.resolve(os.homedir(), '.yarn/link');
                    return [4 /*yield*/, fs.ensureDir(linkDir)];
                case 3:
                    _a.sent();
                    return [4 /*yield*/, fs.realpath(linkDir)];
                case 4:
                    linkDir = _a.sent();
                    return [4 /*yield*/, link(cheTheiaDir, theiaDir, linkDir)];
                case 5:
                    _a.sent();
                    return [3 /*break*/, 7];
                case 6:
                    e_1 = _a.sent();
                    console.error(e_1);
                    return [3 /*break*/, 7];
                case 7: return [2 /*return*/];
            }
        });
    });
}
exports.handleCommand = handleCommand;
function link(cheTheiaProjectPath, theiaProjectPath, yarnLinkFolder) {
    return __awaiter(this, void 0, void 0, function () {
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0: return [4 /*yield*/, linkTheia(yarnLinkFolder, theiaProjectPath)];
                case 1:
                    _a.sent();
                    return [4 /*yield*/, linkChe(yarnLinkFolder, cheTheiaProjectPath)];
                case 2:
                    _a.sent();
                    return [2 /*return*/];
            }
        });
    });
}
exports.link = link;
function linkTheia(yarnLinkFolder, theiaProjectPath) {
    return __awaiter(this, void 0, void 0, function () {
        var _a, _b, rootName, rootPath, folderNames, folderNames_1, folderNames_1_1, folderName, e_2_1, e_3_1;
        var e_3, _c, e_2, _d;
        return __generator(this, function (_e) {
            switch (_e.label) {
                case 0:
                    _e.trys.push([0, 12, 13, 14]);
                    _a = __values(['packages', 'dev-packages', 'examples']), _b = _a.next();
                    _e.label = 1;
                case 1:
                    if (!!_b.done) return [3 /*break*/, 11];
                    rootName = _b.value;
                    rootPath = path.resolve(theiaProjectPath, rootName);
                    return [4 /*yield*/, fs.readdir(rootPath)];
                case 2:
                    folderNames = _e.sent();
                    _e.label = 3;
                case 3:
                    _e.trys.push([3, 8, 9, 10]);
                    folderNames_1 = (e_2 = void 0, __values(folderNames)), folderNames_1_1 = folderNames_1.next();
                    _e.label = 4;
                case 4:
                    if (!!folderNames_1_1.done) return [3 /*break*/, 7];
                    folderName = folderNames_1_1.value;
                    return [4 /*yield*/, new command_1.Command(path.resolve(rootPath, folderName)).exec("yarn link --link-folder=" + yarnLinkFolder)];
                case 5:
                    _e.sent();
                    _e.label = 6;
                case 6:
                    folderNames_1_1 = folderNames_1.next();
                    return [3 /*break*/, 4];
                case 7: return [3 /*break*/, 10];
                case 8:
                    e_2_1 = _e.sent();
                    e_2 = { error: e_2_1 };
                    return [3 /*break*/, 10];
                case 9:
                    try {
                        if (folderNames_1_1 && !folderNames_1_1.done && (_d = folderNames_1.return)) _d.call(folderNames_1);
                    }
                    finally { if (e_2) throw e_2.error; }
                    return [7 /*endfinally*/];
                case 10:
                    _b = _a.next();
                    return [3 /*break*/, 1];
                case 11: return [3 /*break*/, 14];
                case 12:
                    e_3_1 = _e.sent();
                    e_3 = { error: e_3_1 };
                    return [3 /*break*/, 14];
                case 13:
                    try {
                        if (_b && !_b.done && (_c = _a.return)) _c.call(_a);
                    }
                    finally { if (e_3) throw e_3.error; }
                    return [7 /*endfinally*/];
                case 14: return [2 /*return*/];
            }
        });
    });
}
function linkChe(yarnLinkFolder, cheTheiaProjectPath) {
    return __awaiter(this, void 0, void 0, function () {
        var packages, cmd, packages_1, packages_1_1, pkg, e_4_1;
        var e_4, _a;
        return __generator(this, function (_b) {
            switch (_b.label) {
                case 0: return [4 /*yield*/, fs.readdir(path.resolve(yarnLinkFolder, '@theia'))];
                case 1:
                    packages = _b.sent();
                    cmd = new command_1.Command(cheTheiaProjectPath);
                    _b.label = 2;
                case 2:
                    _b.trys.push([2, 7, 8, 9]);
                    packages_1 = __values(packages), packages_1_1 = packages_1.next();
                    _b.label = 3;
                case 3:
                    if (!!packages_1_1.done) return [3 /*break*/, 6];
                    pkg = packages_1_1.value;
                    return [4 /*yield*/, cmd.exec("yarn link @theia/" + pkg)];
                case 4:
                    _b.sent();
                    _b.label = 5;
                case 5:
                    packages_1_1 = packages_1.next();
                    return [3 /*break*/, 3];
                case 6: return [3 /*break*/, 9];
                case 7:
                    e_4_1 = _b.sent();
                    e_4 = { error: e_4_1 };
                    return [3 /*break*/, 9];
                case 8:
                    try {
                        if (packages_1_1 && !packages_1_1.done && (_a = packages_1.return)) _a.call(packages_1);
                    }
                    finally { if (e_4) throw e_4.error; }
                    return [7 /*endfinally*/];
                case 9: return [2 /*return*/];
            }
        });
    });
}
//# sourceMappingURL=link.js.map