/**********************************************************************
 * Copyright (c) 2018-2020 Red Hat, Inc.
 *
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 ***********************************************************************/
/**
 * Generates the assembly directory, copying only subset of files and cleaning up some folders
 * @author Florent Benoit
 */
export declare class Production {
    readonly rootFolder: string;
    readonly assemblyFolder: string;
    readonly productionDirectory: string;
    /**
     * Ensure we've no dependencies to these packages that bring a lot of dependencies !
     */
    private static FORBIDDEN_PACKAGES;
    /**
     * Remove these client dependencies as they're already bundled with webpack
     */
    private static EXCLUDED_PACKAGES;
    private dependencies;
    private toCopyFiles;
    private static readonly ASSEMBLY_DIRECTORY;
    private command;
    constructor(rootFolder: string, assemblyFolder: string, productionDirectory: string);
    create(): Promise<string>;
    protected copyFiles(): Promise<void>;
    protected cleanup(): Promise<void>;
    protected getSize(): Promise<number>;
    protected yarnClean(): Promise<void>;
    protected cleanupFind(): Promise<void>;
    resolveFiles(): Promise<boolean>;
    getDependencies(): Promise<boolean>;
}
//# sourceMappingURL=production.d.ts.map