"use strict";
/**********************************************************************
 * Copyright (c) 2018-2020 Red Hat, Inc.
 *
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 ***********************************************************************/
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.getPackageVersion = exports.getFullPackageName = exports.Yarn = void 0;
var path = require("path");
var cli_error_1 = require("./cli-error");
var command_1 = require("./command");
var init_1 = require("./init");
var logger_1 = require("./logger");
/**
 * Handle the parsing of node packages with Yarn.
 * It allows to grab direct/production dependencies (not the dev dependencies)
 * @author Florent Benoit
 */
var Yarn = /** @class */ (function () {
    function Yarn(rootFolder, dependenciesDirectory, forbiddenPackages, excludedPackages) {
        this.rootFolder = rootFolder;
        this.dependenciesDirectory = dependenciesDirectory;
        this.forbiddenPackages = forbiddenPackages;
        this.excludedPackages = excludedPackages;
    }
    /**
     * Get package.json dependency paths (not including dev dependencies)
     */
    Yarn.prototype.getDependencies = function (rootModule) {
        return __awaiter(this, void 0, void 0, function () {
            var command, stdout, match, inputTrees, configStdout, matchConfig, unescaped, jsonConfig, nodeModulesFolder, nodeTreeDependencies, subsetDependencies, initNode, nodePackages;
            var _this = this;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        command = new command_1.Command(this.dependenciesDirectory);
                        return [4 /*yield*/, command.exec(Yarn.YARN_GET_DEPENDENCIES)];
                    case 1:
                        stdout = _a.sent();
                        match = /^{"type":"tree","data":{"type":"list","trees":(.*)}}$/gm.exec(stdout);
                        if (!match || match.length !== 2) {
                            throw new cli_error_1.CliError('Not able to find a dependency tree when executing ' + Yarn.YARN_GET_DEPENDENCIES + '. Found ' + stdout);
                        }
                        inputTrees = JSON.parse(match[1]);
                        return [4 /*yield*/, command.exec(Yarn.YARN_GET_CONFIG)];
                    case 2:
                        configStdout = _a.sent();
                        matchConfig = /^{"type":"log","data":"(.*)"}$/gm.exec(configStdout);
                        if (!matchConfig || matchConfig.length !== 2) {
                            throw new cli_error_1.CliError('Not able to get yarn configuration when executing ' + Yarn.YARN_GET_CONFIG + '. Found ' + configStdout);
                        }
                        unescaped = matchConfig[1].replace(/\\n/g, '').replace(/\\"/g, '"');
                        jsonConfig = JSON.parse(unescaped);
                        nodeModulesFolder = jsonConfig.modulesFolder;
                        if (!nodeModulesFolder) {
                            nodeModulesFolder = path.resolve(this.rootFolder, 'node_modules');
                        }
                        nodeTreeDependencies = new Map();
                        inputTrees.map(function (yarnNode) { return _this.insertNode(yarnNode, nodeTreeDependencies); });
                        subsetDependencies = [];
                        initNode = nodeTreeDependencies.get(rootModule);
                        if (!initNode) {
                            throw new cli_error_1.CliError("The initial module " + rootModule + " was not found in dependencies");
                        }
                        this.findDependencies(initNode, nodeTreeDependencies, subsetDependencies);
                        nodePackages = [];
                        subsetDependencies.forEach(function (moduleName) { return _this.addNodePackage(nodeModulesFolder, moduleName, nodePackages); });
                        // return unique entries
                        return [2 /*return*/, Promise.resolve(nodePackages.map(function (e) { return e.path; }).filter(function (value, index, array) { return index === array.indexOf(value); }))];
                }
            });
        });
    };
    /**
     * Find from children all the direct dependencies. Also exclude some dependencies by not analyzing them.
     * Allow as well to report error in case of a forbidden dependency found
     * @param children the list of dependencies to analyze
     * @param nodeTreeDependencies the object containing the tree of dependencies
     * @param subsetDependencies  the
     */
    Yarn.prototype.findDependencies = function (children, nodeTreeDependencies, subsetDependencies) {
        var _this = this;
        children.map(function (child) {
            // only loop on exist
            if (subsetDependencies.indexOf(child) >= 0) {
                return;
            }
            subsetDependencies.push(child);
            // loop on children in any
            var depChildren = nodeTreeDependencies.get(child);
            if (depChildren) {
                depChildren = depChildren.filter(function (depChild) {
                    var res = _this.excludedPackages.indexOf(depChild) < 0;
                    if (!res) {
                        logger_1.Logger.debug(" --> Excluding the dependency " + depChild);
                    }
                    return res;
                });
                var matching_1 = [];
                var foundForbiddenPackage = depChildren.some(function (r) {
                    var res = _this.forbiddenPackages.indexOf(r) >= 0;
                    if (res) {
                        matching_1.push(r);
                    }
                    return res;
                });
                if (foundForbiddenPackage) {
                    throw new cli_error_1.CliError("Forbidden dependencies " + matching_1 + " has been found as dependencies of " + child +
                        ("Current dependencies: " + depChildren + ", excluded list: " + _this.forbiddenPackages));
                }
                _this.findDependencies(depChildren, nodeTreeDependencies, subsetDependencies);
            }
        });
    };
    /**
     * Insert the given node into the Map/tree of dependencies
     * @param yarnNode the node to insert
     * @param nodeTreeDependencies the tree to update
     */
    Yarn.prototype.insertNode = function (yarnNode, nodeTreeDependencies) {
        var _this = this;
        var npmModuleName = yarnNode.name.substring(0, yarnNode.name.lastIndexOf('@'));
        // init dependencies object if not existing
        var dependencies = nodeTreeDependencies.get(npmModuleName);
        if (!dependencies) {
            dependencies = [];
            nodeTreeDependencies.set(npmModuleName, dependencies);
        }
        // insert all children as well
        if (yarnNode.children) {
            yarnNode.children.map(function (child) {
                var childName = child.name.substring(0, child.name.lastIndexOf('@'));
                dependencies.push(childName);
                _this.insertNode(child, nodeTreeDependencies);
            });
        }
    };
    /**
     * Add a node package (entry of yarn list) to the given array.
     * Also loop on all children and call ourself back
     * @param nodeModulesFolder the node_modules location
     * @param yarnNode the node entry to add
     * @param packages the array representing all node dependencies
     */
    Yarn.prototype.addNodePackage = function (nodeModulesFolder, moduleName, packages) {
        return __awaiter(this, void 0, void 0, function () {
            var nodePackage;
            return __generator(this, function (_a) {
                nodePackage = { name: moduleName, path: path.resolve(nodeModulesFolder, moduleName) };
                // add to the array
                packages.push(nodePackage);
                return [2 /*return*/];
            });
        });
    };
    /**
     * Command to grab dependencies
     */
    Yarn.YARN_GET_DEPENDENCIES = 'yarn list --json --prod';
    /**
     * Command to grab yarn configuration.
     */
    Yarn.YARN_GET_CONFIG = 'yarn config current --json';
    return Yarn;
}());
exports.Yarn = Yarn;
/**
 * Returns the full package name of an installed package or the emtpy string if not installed
 */
function getFullPackageName(rootFolder, name) {
    return __awaiter(this, void 0, void 0, function () {
        var pkg, _a, _b;
        return __generator(this, function (_c) {
            switch (_c.label) {
                case 0:
                    _b = (_a = JSON).parse;
                    return [4 /*yield*/, new command_1.Command(path.resolve(rootFolder)).exec(init_1.Init.GET_PACKAGE_WITH_VERSION_CMD + name)];
                case 1:
                    pkg = _b.apply(_a, [_c.sent()])
                        .data.trees[0];
                    return [2 /*return*/, pkg ? pkg.name : ''];
            }
        });
    });
}
exports.getFullPackageName = getFullPackageName;
/**
 * Returns the version of an installed package or the emtpy string if not installed
 */
function getPackageVersion(rootFolder, name) {
    return __awaiter(this, void 0, void 0, function () {
        var nameWithVersion;
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0:
                    nameWithVersion = getFullPackageName(rootFolder, name);
                    return [4 /*yield*/, nameWithVersion];
                case 1: return [2 /*return*/, (_a.sent()).split('@').pop() || ''];
            }
        });
    });
}
exports.getPackageVersion = getPackageVersion;
//# sourceMappingURL=yarn.js.map