cd? cd
======

Extra small nodejs module for chdir in chainer fashion + read file.

Install:

    npm install cd

To run tests enter module dir and run:

    node test.js

Rules:

    1. Reading .json will strip comments and convert to JSON.
    2. Reading .js is equivalent of require() that file.
    3. Other files are just read.
    4. Supply file as argument on last call. No chaning afterwards.
    5. Module is synchro. Hmmm, do we really need async version?

Usage:

    var cd = require('cd');

    // You can use any path you like, not only current dir '.'
    var dir = new cd('.');

    // Read ./lol.json
    var lol = dir('lol.json');

    // Read ./test/wtf.js directory.
    var wtf = dir().test('wtf.js');

    // Chain as you like: ./dir1/dir2/fileInDir2
    var file = dir().dir1().dir2(fileInDir2);

    /*
     * Use try/catch for safety (non-existent dirs)
     */
    try {
      content = dir().existDir1().nonexistDir().someDir(someDirFile);
    } catch(e) {
      // ...
    }

If you have cool and pragmatic idea let me know.
This module is not going to grow much, there is no need for yet another bloated module.
