# set-getter [![NPM version](https://img.shields.io/npm/v/set-getter.svg?style=flat)](https://www.npmjs.com/package/set-getter) [![NPM downloads](https://img.shields.io/npm/dm/set-getter.svg?style=flat)](https://npmjs.org/package/set-getter) [![Build Status](https://img.shields.io/travis/doowb/set-getter.svg?style=flat)](https://travis-ci.org/doowb/set-getter)

> Create nested getter properties and any intermediary dot notation (`'a.b.c'`) paths

## Install

Install with [npm](https://www.npmjs.com/):

```sh
$ npm install set-getter --save
```

## Usage

```js
var getter = require('set-getter');
```

set-getter works like [set-value](https://github.com/jonschlinkert/set-value) by adding a property to an object or an object hierarchy using dot notation. The main difference is that the property is added using `Object.defineProperty` and is expected to be a getter function that returns a value.

**Example**

```js
var obj = {};

// root level property
getter(obj, 'foo', function() {
  return 'bar';
});
console.log(obj.foo);
//=> 'bar'

// property dot notation
getter(obj, 'bar.baz', function() {
  return 'qux';
});
console.log(obj.bar.baz);
//=> 'qux'

// property array notation
getter(obj, ['beep', 'boop'], function() {
  return 'bop';
});
console.log(obj.beep.boop);
//=> 'bop'
```

## API

### [setGetter](index.js#L27)

Defines a getter function on an object using property path notation.

**Params**

* `obj` **{Object}**: Object to add property to.
* `prop` **{String|Array}**: Property string or array to add.
* `getter` **{Function}**: Getter function to add as a property.

**Example**

```js
var obj = {};
getter(obj, 'foo', function() {
  return 'bar';
});
```

## Contributing

Pull requests and stars are always welcome. For bugs and feature requests, [please create an issue](https://github.com/doowb/set-getter/issues/new).

## Building docs

Generate readme and API documentation with [verb](https://github.com/verbose/verb):

```sh
$ npm install verb && npm run docs
```

Or, if [verb](https://github.com/verbose/verb) is installed globally:

```sh
$ verb
```

## Running tests

Install dev dependencies:

```sh
$ npm install -d && npm test
```

## Author

**Brian Woodward**

* [github/doowb](https://github.com/doowb)
* [twitter/doowb](http://twitter.com/doowb)

## License

Copyright © 2016, [Brian Woodward](https://github.com/doowb).
Released under the [MIT license](https://github.com/doowb/set-getter/blob/master/LICENSE).

***

_This file was generated by [verb](https://github.com/verbose/verb), v0.9.0, on April 29, 2016._