"use strict";
/**********************************************************************
 * Copyright (c) 2018-2020 Red Hat, Inc.
 *
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 ***********************************************************************/
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.Init = void 0;
var fs = require("fs-extra");
var mustache = require("mustache");
var path = require("path");
var readPkg = require("read-pkg");
var command_1 = require("./command");
var logger_1 = require("./logger");
/**
 * Generates the examples/assembly
 * @author Florent Benoit
 */
var Init = /** @class */ (function () {
    function Init(rootFolder, examplesAssemblyFolder, checkoutFolder, pluginsFolder) {
        this.rootFolder = rootFolder;
        this.examplesAssemblyFolder = examplesAssemblyFolder;
        this.checkoutFolder = checkoutFolder;
        this.pluginsFolder = pluginsFolder;
    }
    Init.prototype.getCurrentVersion = function () {
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0: return [4 /*yield*/, readPkg(path.join(this.rootFolder, 'packages/core/package.json'))];
                    case 1: return [2 /*return*/, (_a.sent()).version];
                }
            });
        });
    };
    Init.prototype.getPackageWithVersion = function (name) {
        return __awaiter(this, void 0, void 0, function () {
            var pkg, _a, _b;
            return __generator(this, function (_c) {
                switch (_c.label) {
                    case 0:
                        _b = (_a = JSON).parse;
                        return [4 /*yield*/, new command_1.Command(path.resolve(this.rootFolder)).exec(Init.GET_PACKAGE_WITH_VERSION_CMD + name)];
                    case 1:
                        pkg = _b.apply(_a, [_c.sent()]).data.trees[0];
                        return [2 /*return*/, pkg ? pkg.name : ''];
                }
            });
        });
    };
    Init.prototype.generate = function () {
        return __awaiter(this, void 0, void 0, function () {
            var srcDir, distDir, templateDir, compileTsConfig, packageJsonContent, rendered;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        srcDir = path.resolve(__dirname, '../src');
                        distDir = path.resolve(__dirname, '../dist');
                        templateDir = path.join(srcDir, 'templates');
                        compileTsConfig = path.join(templateDir, 'assembly-compile.tsconfig.json');
                        return [4 /*yield*/, fs.readFile(path.join(templateDir, 'assembly-package.mst'))];
                    case 1:
                        packageJsonContent = _a.sent();
                        return [4 /*yield*/, this.generateAssemblyPackage(packageJsonContent.toString())];
                    case 2:
                        rendered = _a.sent();
                        return [4 /*yield*/, fs.ensureDir(this.examplesAssemblyFolder)];
                    case 3:
                        _a.sent();
                        return [4 /*yield*/, fs.writeFile(path.join(this.examplesAssemblyFolder, 'package.json'), rendered)];
                    case 4:
                        _a.sent();
                        return [4 /*yield*/, fs.copy(compileTsConfig, path.join(this.examplesAssemblyFolder, 'compile.tsconfig.json'))];
                    case 5:
                        _a.sent();
                        return [4 /*yield*/, fs.copy(path.join(templateDir, 'cdn'), path.join(this.examplesAssemblyFolder, 'cdn'))];
                    case 6:
                        _a.sent();
                        logger_1.Logger.info(distDir);
                        return [4 /*yield*/, fs.copy(path.join(distDir, 'cdn'), path.join(this.examplesAssemblyFolder, 'cdn'))];
                    case 7:
                        _a.sent();
                        return [4 /*yield*/, fs.copy(path.join(srcDir, 'scripts'), path.join(this.examplesAssemblyFolder, 'scripts'))];
                    case 8:
                        _a.sent();
                        // Generate checkout folder is does not exist
                        return [4 /*yield*/, fs.ensureDir(this.checkoutFolder)];
                    case 9:
                        // Generate checkout folder is does not exist
                        _a.sent();
                        // copy build all plugins scripts
                        return [4 /*yield*/, fs.ensureDir(this.pluginsFolder)];
                    case 10:
                        // copy build all plugins scripts
                        _a.sent();
                        return [4 /*yield*/, fs.copy(path.join(srcDir, 'foreach_yarn'), path.join(this.pluginsFolder, 'foreach_yarn'))];
                    case 11:
                        _a.sent();
                        return [2 /*return*/];
                }
            });
        });
    };
    Init.prototype.generateAssemblyPackage = function (template) {
        return __awaiter(this, void 0, void 0, function () {
            var tags;
            var _a;
            return __generator(this, function (_b) {
                switch (_b.label) {
                    case 0:
                        _a = {};
                        return [4 /*yield*/, this.getCurrentVersion()];
                    case 1:
                        _a.version = _b.sent();
                        return [4 /*yield*/, this.getPackageWithVersion(Init.MONACO_CORE_PKG)];
                    case 2:
                        tags = (_a.monacopkg = _b.sent(),
                            _a);
                        return [2 /*return*/, mustache.render(template, tags).replace(/&#x2F;/g, '/')];
                }
            });
        });
    };
    Init.prototype.updadeBuildConfiguration = function (extensions) {
        return __awaiter(this, void 0, void 0, function () {
            var theiaPackagePath, theiaPackage, scriptsConfiguration, theiaDevDependencies, prettierConfiguration, importSortConfiguration, appendDevDependencies, json;
            var _this = this;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        theiaPackagePath = path.join(this.rootFolder, 'package.json');
                        return [4 /*yield*/, readPkg(theiaPackagePath)];
                    case 1:
                        theiaPackage = _a.sent();
                        scriptsConfiguration = theiaPackage.scripts;
                        if (scriptsConfiguration && scriptsConfiguration['prepare:build']) {
                            scriptsConfiguration['prepare:build'] = 'yarn build && run lint && lerna run build';
                        }
                        theiaDevDependencies = theiaPackage.devDependencies || {};
                        prettierConfiguration = theiaPackage.prettier || {};
                        importSortConfiguration = theiaPackage.importSort || {};
                        appendDevDependencies = new Map();
                        // add prettier and linters used by extensions
                        return [4 /*yield*/, Promise.all(extensions.map(function (extension) { return __awaiter(_this, void 0, void 0, function () {
                                var extensionPackagePath, exists, extensionPackage_1, keys;
                                return __generator(this, function (_a) {
                                    switch (_a.label) {
                                        case 0:
                                            extensionPackagePath = path.join(extension.clonedDir, 'package.json');
                                            return [4 /*yield*/, fs.pathExists(extensionPackagePath)];
                                        case 1:
                                            exists = _a.sent();
                                            if (!exists) return [3 /*break*/, 3];
                                            return [4 /*yield*/, readPkg(extensionPackagePath)];
                                        case 2:
                                            extensionPackage_1 = _a.sent();
                                            if (extensionPackage_1.prettier) {
                                                Object.keys(extensionPackage_1.prettier).forEach(function (key) {
                                                    prettierConfiguration[key] = extensionPackage_1.prettier[key];
                                                });
                                            }
                                            if (extensionPackage_1.importSort) {
                                                Object.keys(extensionPackage_1.importSort).forEach(function (key) {
                                                    importSortConfiguration[key] = extensionPackage_1.importSort[key];
                                                });
                                            }
                                            if (extensionPackage_1.devDependencies) {
                                                keys = Object.keys(extensionPackage_1.devDependencies).filter(function (key) {
                                                    return !theiaDevDependencies[key] &&
                                                        (key.includes('prettier') || key.includes('eslint') || key === 'if-env');
                                                });
                                                keys.forEach(function (key) { return appendDevDependencies.set(key, extensionPackage_1.devDependencies[key]); });
                                            }
                                            _a.label = 3;
                                        case 3: return [2 /*return*/];
                                    }
                                });
                            }); }))];
                    case 2:
                        // add prettier and linters used by extensions
                        _a.sent();
                        // grab all prettier, eslint stuff
                        theiaPackage.prettier = prettierConfiguration;
                        theiaPackage.importSort = importSortConfiguration;
                        appendDevDependencies.forEach(function (value, key) { return (theiaDevDependencies[key] = value); });
                        json = JSON.stringify(theiaPackage, undefined, 2);
                        return [4 /*yield*/, fs.writeFile(theiaPackagePath, json)];
                    case 3:
                        _a.sent();
                        return [2 /*return*/];
                }
            });
        });
    };
    Init.prototype.updatePluginsConfigurtion = function () {
        return __awaiter(this, void 0, void 0, function () {
            var theiaPackagePath, theiaPackage, _a, _b, json;
            return __generator(this, function (_c) {
                switch (_c.label) {
                    case 0:
                        theiaPackagePath = path.join(this.rootFolder, 'package.json');
                        return [4 /*yield*/, readPkg(theiaPackagePath)];
                    case 1:
                        theiaPackage = _c.sent();
                        _a = theiaPackage;
                        _b = 'theiaPlugins';
                        return [4 /*yield*/, this.getPluginsList()];
                    case 2:
                        _a[_b] = _c.sent();
                        json = JSON.stringify(theiaPackage, undefined, 2);
                        return [4 /*yield*/, fs.writeFile(theiaPackagePath, json)];
                    case 3:
                        _c.sent();
                        return [2 /*return*/];
                }
            });
        });
    };
    // eslint-disable-next-line @typescript-eslint/no-explicit-any
    Init.prototype.getPluginsList = function () {
        return __awaiter(this, void 0, void 0, function () {
            var srcDir, templateDir, pluginsJsonContent;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        srcDir = path.resolve(__dirname, '../src');
                        templateDir = path.join(srcDir, 'templates');
                        return [4 /*yield*/, fs.readFile(path.join(templateDir, 'theiaPlugins.json'))];
                    case 1:
                        pluginsJsonContent = _a.sent();
                        return [2 /*return*/, JSON.parse(pluginsJsonContent.toString())];
                }
            });
        });
    };
    Init.GET_PACKAGE_WITH_VERSION_CMD = 'yarn --json --non-interactive --no-progress list --pattern=';
    Init.MONACO_CORE_PKG = '@theia/monaco-editor-core';
    return Init;
}());
exports.Init = Init;
//# sourceMappingURL=init.js.map