"use strict";
/*********************************************************************
* Copyright (c) 2018 Red Hat, Inc.
*
* This program and the accompanying materials are made
* available under the terms of the Eclipse Public License 2.0
* which is available at https://www.eclipse.org/legal/epl-2.0/
*
* SPDX-License-Identifier: EPL-2.0
**********************************************************************/
Object.defineProperty(exports, "__esModule", { value: true });
const fs = require("fs");
class TemplateWriter {
    constructor(generator) {
        this.generator = generator;
    }
    pluginPath(params, path) {
        return this.generator.destinationPath(params.distFolder + '/' + path);
    }
    write(params) {
        this.writeBase(params);
        switch (params.template) {
            case 'hello-world':
                this.writeMain('hello-world.ts', params);
                break;
            case 'skeleton':
                this.writeMain('empty/index.ts', params);
                break;
            case 'samples':
                this.writeSample(params.sample, params);
                break;
        }
    }
    writeSample(sample, params) {
        if (!sample) {
            sample = this.generator.options.sample;
        }
        const path = 'samples/' + sample + '/';
        this.writeMain(path + 'index.ts', params);
        if (fs.existsSync(this.generator.templatePath(path) + 'package.json')) {
            this.generator.fs.copyTpl(this.generator.templatePath(path) + 'package.json', this.pluginPath(params, 'package.json'), { params: params });
        }
        if (fs.readdirSync(this.generator.templatePath(path)).length > 1) {
            try {
                this.generator.fs.copyTpl(this.generator.templatePath(path) + '!(index.ts|package.json)', this.pluginPath(params, 'src'), { params: params }, {}, { globOptions: { dot: true } });
            }
            catch (e) {
                console.debug(e);
            }
        }
    }
    writeMain(indexPath, params) {
        this.generator.fs.copyTpl(this.generator.templatePath(indexPath), this.pluginPath(params, 'src/' + params.pluginSourcePath), { params: params });
    }
    writeBase(params) {
        this.generator.fs.copyTpl(this.generator.templatePath('base/package.json'), this.pluginPath(params, 'package.json'), { params: params });
        this.generator.fs.copyTpl(this.generator.templatePath('base/gitignore'), this.pluginPath(params, '.gitignore'), { params: params });
        this.generator.fs.copyTpl(this.generator.templatePath('base/README.md'), this.pluginPath(params, 'README.md'), { params: params });
        this.generator.fs.copyTpl(this.generator.templatePath('base/tsconfig.json'), this.pluginPath(params, 'tsconfig.json'), { params: params });
        this.generator.fs.copyTpl(this.generator.templatePath('base/tsfmt.json'), this.pluginPath(params, 'tsfmt.json'), { params: params });
        if (params.isFrontend) {
            this.generator.fs.copyTpl(this.generator.templatePath('base/webpack.config.js'), this.pluginPath(params, 'webpack.config.js'), { params: params });
        }
        if (params.license.id !== 'none') {
            this.generator.fs.copyTpl(this.generator.templatePath('licenses/' + params.license.id + '/license'), this.pluginPath(params, 'LICENSE'), { params: params });
        }
    }
}
exports.TemplateWriter = TemplateWriter;
//# sourceMappingURL=template-writer.js.map