"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.resolveSync = exports.resolve = void 0;
const loader_pool_1 = require("./loader-pool");
const options_1 = require("./options");
const node_loader_1 = require("./node-loader");
Object.defineProperty(exports, "resolveSync", { enumerable: true, get: function () { return node_loader_1.resolveSync; } });
function renderSortedObject(entries) {
    return entries.sort().reduce((obj, [key, value]) => {
        return Object.assign(obj, { [key]: value });
    }, {});
}
async function resolve(...options) {
    const opts = options_1.normalizeOptions(options), loader = new loader_pool_1.Loader(opts);
    await loader.setup();
    const res = await Promise.all(opts.entries.map((request) => loader.loadEntry(opts.cwd, request, opts.files))), warnings = [], entries = opts.entries.sort().reduce((entryMap, entry, i) => {
        entryMap[entry] = res[i].entry;
        warnings.push(...res[i].warnings);
        return entryMap;
    }, {}), files = renderSortedObject(Object.entries(opts.files));
    loader.quit();
    return { files, entries, warnings };
}
exports.default = resolve;
exports.resolve = resolve;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoicmVzb2x2ZS5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uL3NyYy9yZXNvbHZlLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7OztBQUFBLCtDQUFzQztBQUV0Qyx1Q0FBK0Q7QUFDL0QsK0NBQTJDO0FBd0J6Qiw0RkF4QlQseUJBQVcsT0F3QlM7QUF0QjdCLFNBQVMsa0JBQWtCLENBQUMsT0FBZ0M7SUFDMUQsT0FBTyxPQUFPLENBQUMsSUFBSSxFQUFFLENBQUMsTUFBTSxDQUFDLENBQUMsR0FBRyxFQUFFLENBQUMsR0FBRyxFQUFFLEtBQUssQ0FBQyxFQUFFLEVBQUU7UUFDakQsT0FBTyxNQUFNLENBQUMsTUFBTSxDQUFDLEdBQUcsRUFBRSxFQUFFLENBQUMsR0FBRyxDQUFDLEVBQUUsS0FBSyxFQUFFLENBQUMsQ0FBQTtJQUM3QyxDQUFDLEVBQUUsRUFBRSxDQUFDLENBQUE7QUFDUixDQUFDO0FBRWMsS0FBSyxVQUFVLE9BQU8sQ0FBQyxHQUFHLE9BQWdEO0lBQ3ZGLE1BQU0sSUFBSSxHQUFHLDBCQUFnQixDQUFDLE9BQU8sQ0FBQyxFQUNwQyxNQUFNLEdBQUcsSUFBSSxvQkFBTSxDQUFDLElBQUksQ0FBQyxDQUFBO0lBQzNCLE1BQU0sTUFBTSxDQUFDLEtBQUssRUFBRSxDQUFBO0lBRXBCLE1BQU0sR0FBRyxHQUFHLE1BQU0sT0FBTyxDQUFDLEdBQUcsQ0FBQyxJQUFJLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxDQUFDLE9BQU8sRUFBRSxFQUFFLENBQUMsTUFBTSxDQUFDLFNBQVMsQ0FBQyxJQUFJLENBQUMsR0FBRyxFQUFFLE9BQU8sRUFBRSxJQUFJLENBQUMsS0FBSyxDQUFDLENBQUMsQ0FBQyxFQUMzRyxRQUFRLEdBQWEsRUFBRSxFQUN2QixPQUFPLEdBQUcsSUFBSSxDQUFDLE9BQU8sQ0FBQyxJQUFJLEVBQUUsQ0FBQyxNQUFNLENBQUMsQ0FBQyxRQUFRLEVBQUUsS0FBSyxFQUFFLENBQUMsRUFBRSxFQUFFO1FBQzFELFFBQVEsQ0FBQyxLQUFLLENBQUMsR0FBRyxHQUFHLENBQUMsQ0FBQyxDQUFDLENBQUMsS0FBTSxDQUFBO1FBQy9CLFFBQVEsQ0FBQyxJQUFJLENBQUMsR0FBRyxHQUFHLENBQUMsQ0FBQyxDQUFDLENBQUMsUUFBUSxDQUFDLENBQUE7UUFDakMsT0FBTyxRQUFRLENBQUE7SUFDakIsQ0FBQyxFQUFFLEVBQTZCLENBQUMsRUFDakMsS0FBSyxHQUFHLGtCQUFrQixDQUFDLE1BQU0sQ0FBQyxPQUFPLENBQUMsSUFBSSxDQUFDLEtBQUssQ0FBQyxDQUFDLENBQUE7SUFDeEQsTUFBTSxDQUFDLElBQUksRUFBRSxDQUFBO0lBQ2IsT0FBTyxFQUFFLEtBQUssRUFBRSxPQUFPLEVBQUUsUUFBUSxFQUFFLENBQUE7QUFDckMsQ0FBQztBQWZELDBCQWVDO0FBQ1EsMEJBQU8ifQ==