"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.WorkerThread = void 0;
const child_process_1 = require("child_process");
const async_1 = require("@calebboyd/async");
class WorkerThread {
    constructor({ taskConccurency = 10 } = {}) {
        this.pending = {};
        this.child = child_process_1.fork(require.resolve('./worker-runtime'));
        this.lock = new async_1.Semaphore(taskConccurency);
        this.child.on('message', (message) => {
            this.lock.release();
            const waiter = this.pending[message.id];
            delete this.pending[message.id];
            if (message.error) {
                waiter.reject(new Error(message.error));
            }
            else {
                waiter.resolve(message.result);
            }
        });
    }
    sendMessage(message) {
        return this.lock.acquire().then((id) => {
            this.child.send({ id, ...message });
            return (this.pending[id] = async_1.createDeferred()).promise;
        });
    }
    end() {
        this.child.kill();
    }
}
exports.WorkerThread = WorkerThread;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoid29ya2VyLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiLi4vc3JjL3dvcmtlci50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7QUFBQSxpREFBb0M7QUFFcEMsNENBQXNFO0FBUXRFLE1BQWEsWUFBWTtJQUl2QixZQUFZLEVBQUUsZUFBZSxHQUFHLEVBQUUsRUFBRSxHQUFHLEVBQUU7UUFGakMsWUFBTyxHQUE0RCxFQUFFLENBQUE7UUFDckUsVUFBSyxHQUFHLG9CQUFJLENBQUMsT0FBTyxDQUFDLE9BQU8sQ0FBQyxrQkFBa0IsQ0FBQyxDQUFDLENBQUE7UUFFdkQsSUFBSSxDQUFDLElBQUksR0FBRyxJQUFJLGlCQUFTLENBQUMsZUFBZSxDQUFDLENBQUE7UUFDMUMsSUFBSSxDQUFDLEtBQUssQ0FBQyxFQUFFLENBQUMsU0FBUyxFQUFFLENBQUMsT0FBbUIsRUFBRSxFQUFFO1lBQy9DLElBQUksQ0FBQyxJQUFJLENBQUMsT0FBTyxFQUFFLENBQUE7WUFDbkIsTUFBTSxNQUFNLEdBQUcsSUFBSSxDQUFDLE9BQU8sQ0FBQyxPQUFPLENBQUMsRUFBRSxDQUFDLENBQUE7WUFDdkMsT0FBTyxJQUFJLENBQUMsT0FBTyxDQUFDLE9BQU8sQ0FBQyxFQUFFLENBQUMsQ0FBQTtZQUMvQixJQUFJLE9BQU8sQ0FBQyxLQUFLLEVBQUU7Z0JBQ2pCLE1BQU0sQ0FBQyxNQUFNLENBQUMsSUFBSSxLQUFLLENBQUMsT0FBTyxDQUFDLEtBQUssQ0FBQyxDQUFDLENBQUE7YUFDeEM7aUJBQU07Z0JBQ0wsTUFBTSxDQUFDLE9BQU8sQ0FBQyxPQUFPLENBQUMsTUFBTSxDQUFDLENBQUE7YUFDL0I7UUFDSCxDQUFDLENBQUMsQ0FBQTtJQUNKLENBQUM7SUFFRCxXQUFXLENBQUMsT0FBZ0I7UUFDMUIsT0FBTyxJQUFJLENBQUMsSUFBSSxDQUFDLE9BQU8sRUFBRSxDQUFDLElBQUksQ0FBQyxDQUFDLEVBQVUsRUFBRSxFQUFFO1lBQzdDLElBQUksQ0FBQyxLQUFLLENBQUMsSUFBSSxDQUFDLEVBQUUsRUFBRSxFQUFFLEdBQUcsT0FBTyxFQUFFLENBQUMsQ0FBQTtZQUNuQyxPQUFPLENBQUMsSUFBSSxDQUFDLE9BQU8sQ0FBQyxFQUFFLENBQUMsR0FBRyxzQkFBYyxFQUE4QixDQUFDLENBQUMsT0FBTyxDQUFBO1FBQ2xGLENBQUMsQ0FBQyxDQUFBO0lBQ0osQ0FBQztJQUVELEdBQUc7UUFDRCxJQUFJLENBQUMsS0FBSyxDQUFDLElBQUksRUFBRSxDQUFBO0lBQ25CLENBQUM7Q0FDRjtBQTVCRCxvQ0E0QkMifQ==