"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.normalizeOptions = void 0;
function normalizeOptions(args) {
    const options = {
        entries: [],
        cwd: process.cwd(),
        loadContent: true,
        expand: 'none',
        files: {},
    };
    args.forEach((x) => {
        if (typeof x === 'string')
            return options.entries.push(x);
        if (x.cwd)
            options.cwd = x.cwd;
        if (Array.isArray(x.entries))
            options.entries.push(...x.entries);
        if ('expand' in x)
            options.expand = x.expand || 'none';
        if ('loadContent' in x)
            options.loadContent = Boolean(x.loadContent);
        if ('files' in x)
            Object.assign(options.files, x.files);
    });
    options.entries = Array.from(new Set(options.entries));
    if (!options.entries.length) {
        try {
            options.entries.push(require.resolve(options.cwd));
        }
        catch (e) {
            throw new Error('No entry file found');
        }
    }
    return options;
}
exports.normalizeOptions = normalizeOptions;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoib3B0aW9ucy5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uL3NyYy9vcHRpb25zLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7OztBQVlBLFNBQWdCLGdCQUFnQixDQUFDLElBQTJDO0lBQzFFLE1BQU0sT0FBTyxHQUFHO1FBQ2QsT0FBTyxFQUFFLEVBQWM7UUFDdkIsR0FBRyxFQUFFLE9BQU8sQ0FBQyxHQUFHLEVBQUU7UUFDbEIsV0FBVyxFQUFFLElBQUk7UUFDakIsTUFBTSxFQUFFLE1BQW1CO1FBQzNCLEtBQUssRUFBRSxFQUFhO0tBQ3JCLENBQUE7SUFFRCxJQUFJLENBQUMsT0FBTyxDQUFDLENBQUMsQ0FBQyxFQUFFLEVBQUU7UUFDakIsSUFBSSxPQUFPLENBQUMsS0FBSyxRQUFRO1lBQUUsT0FBTyxPQUFPLENBQUMsT0FBTyxDQUFDLElBQUksQ0FBQyxDQUFDLENBQUMsQ0FBQTtRQUN6RCxJQUFJLENBQUMsQ0FBQyxHQUFHO1lBQUUsT0FBTyxDQUFDLEdBQUcsR0FBRyxDQUFDLENBQUMsR0FBRyxDQUFBO1FBQzlCLElBQUksS0FBSyxDQUFDLE9BQU8sQ0FBQyxDQUFDLENBQUMsT0FBTyxDQUFDO1lBQUUsT0FBTyxDQUFDLE9BQU8sQ0FBQyxJQUFJLENBQUMsR0FBRyxDQUFDLENBQUMsT0FBTyxDQUFDLENBQUE7UUFDaEUsSUFBSSxRQUFRLElBQUksQ0FBQztZQUFFLE9BQU8sQ0FBQyxNQUFNLEdBQUcsQ0FBQyxDQUFDLE1BQU0sSUFBSSxNQUFNLENBQUE7UUFDdEQsSUFBSSxhQUFhLElBQUksQ0FBQztZQUFFLE9BQU8sQ0FBQyxXQUFXLEdBQUcsT0FBTyxDQUFDLENBQUMsQ0FBQyxXQUFXLENBQUMsQ0FBQTtRQUNwRSxJQUFJLE9BQU8sSUFBSSxDQUFDO1lBQUUsTUFBTSxDQUFDLE1BQU0sQ0FBQyxPQUFPLENBQUMsS0FBSyxFQUFFLENBQUMsQ0FBQyxLQUFLLENBQUMsQ0FBQTtJQUN6RCxDQUFDLENBQUMsQ0FBQTtJQUVGLE9BQU8sQ0FBQyxPQUFPLEdBQUcsS0FBSyxDQUFDLElBQUksQ0FBQyxJQUFJLEdBQUcsQ0FBQyxPQUFPLENBQUMsT0FBTyxDQUFDLENBQUMsQ0FBQTtJQUV0RCxJQUFJLENBQUMsT0FBTyxDQUFDLE9BQU8sQ0FBQyxNQUFNLEVBQUU7UUFDM0IsSUFBSTtZQUNGLE9BQU8sQ0FBQyxPQUFPLENBQUMsSUFBSSxDQUFDLE9BQU8sQ0FBQyxPQUFPLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxDQUFDLENBQUE7U0FDbkQ7UUFBQyxPQUFPLENBQUMsRUFBRTtZQUNWLE1BQU0sSUFBSSxLQUFLLENBQUMscUJBQXFCLENBQUMsQ0FBQTtTQUN2QztLQUNGO0lBQ0QsT0FBTyxPQUFPLENBQUE7QUFDaEIsQ0FBQztBQTVCRCw0Q0E0QkMifQ==