"use strict";
/**********************************************************************
 * Copyright (c) 2020 Red Hat, Inc.
 *
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 ***********************************************************************/
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.CheTheiaPluginDevContainerMerger = void 0;
const inversify_1 = require("inversify");
/**
 * When extensions will run in the dev container, need to aggregate all settings of all extensions like extensions, preferences, volume mounts and endpoints
 */
let CheTheiaPluginDevContainerMerger = class CheTheiaPluginDevContainerMerger {
    merge(extensionsWithSidecars) {
        const extensions = [
            ...new Set(extensionsWithSidecars
                .map(extension => extension.extensions)
                // flatten the array of array
                .reduce((acc, val) => acc.concat(val), [])),
        ];
        // merge preferences
        const allPreferences = extensionsWithSidecars
            .map(extension => extension.preferences || {})
            .reduce((acc, val) => acc.concat(val), []);
        const preferences = Object.assign({}, ...allPreferences);
        // all volume mounts
        const volumeMounts = extensionsWithSidecars
            .map(extension => extension.sidecar.volumeMounts || [])
            .reduce((acc, val) => acc.concat(val), []);
        // all endpoints
        const endpoints = extensionsWithSidecars
            .map(extension => extension.sidecar.endpoints || [])
            .reduce((acc, val) => acc.concat(val), []);
        return {
            extensions,
            preferences,
            volumeMounts,
            endpoints,
        };
    }
};
CheTheiaPluginDevContainerMerger = __decorate([
    inversify_1.injectable()
], CheTheiaPluginDevContainerMerger);
exports.CheTheiaPluginDevContainerMerger = CheTheiaPluginDevContainerMerger;
//# sourceMappingURL=che-theia-plugin-devcontainer-merger.js.map