"use strict";
/**********************************************************************
 * Copyright (c) 2021 Red Hat, Inc.
 *
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 ***********************************************************************/
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.DevWorkspaceUpdater = void 0;
const inversify_1 = require("inversify");
const che_theia_component_updater_1 = require("./che-theia-component-updater");
const dev_container_component_updater_1 = require("./dev-container-component-updater");
const sidecar_components_creator_1 = require("./sidecar-components-creator");
/**
 * This class is responsible to:
 *  - add annotations about vsix files to add on che-theia component
 *  - add sidecar components + their vsix files
 *  - add vsix installer component
 */
let DevWorkspaceUpdater = class DevWorkspaceUpdater {
    async update(devfileContext, cheTheiaExtensions, extensionsWithSidecars, extensionsForDevContainer) {
        var _a;
        if (!((_a = devfileContext.devWorkspace.spec) === null || _a === void 0 ? void 0 : _a.template)) {
            throw new Error('Can update a dev workspace only if there is a template in spec object');
        }
        const components = devfileContext.devWorkspace.spec.template.components || [];
        if (!devfileContext.devWorkspace.spec.template.components) {
            devfileContext.devWorkspace.spec.template.components = components;
        }
        // need to add the kubernetes plug-in in the devWorkspace object
        if (this.insertTemplates) {
            devfileContext.devWorkspaceTemplates.map(template => {
                var _a;
                // eslint-disable-next-line @typescript-eslint/no-explicit-any
                const name = (_a = template.metadata) === null || _a === void 0 ? void 0 : _a.name;
                if (!name) {
                    throw new Error(`No name found for the template ${JSON.stringify(template, undefined, 2)}.`);
                }
                components.push({
                    name,
                    plugin: {
                        kubernetes: {
                            name,
                        },
                    },
                });
            });
        }
        // first, update theia component to add the vsix URLS, preferences, etc
        this.cheTheiaComponentUpdater.insert(devfileContext, cheTheiaExtensions);
        // then, generate sidecar components to add (if any)
        const componentsToAdd = await this.sidecarComponentsCreator.create(extensionsWithSidecars);
        // finally, update dev container component with extensions to be deployed there
        if (extensionsForDevContainer) {
            this.devContainerComponentUpdater.insert(devfileContext, extensionsForDevContainer);
        }
        // and add them
        devfileContext.devWorkspace.spec.template.components.push(...componentsToAdd);
    }
};
__decorate([
    inversify_1.inject(sidecar_components_creator_1.SidecarComponentsCreator),
    __metadata("design:type", sidecar_components_creator_1.SidecarComponentsCreator)
], DevWorkspaceUpdater.prototype, "sidecarComponentsCreator", void 0);
__decorate([
    inversify_1.inject(che_theia_component_updater_1.CheTheiaComponentUpdater),
    __metadata("design:type", che_theia_component_updater_1.CheTheiaComponentUpdater)
], DevWorkspaceUpdater.prototype, "cheTheiaComponentUpdater", void 0);
__decorate([
    inversify_1.inject(dev_container_component_updater_1.DevContainerComponentUpdater),
    __metadata("design:type", dev_container_component_updater_1.DevContainerComponentUpdater)
], DevWorkspaceUpdater.prototype, "devContainerComponentUpdater", void 0);
__decorate([
    inversify_1.inject('boolean'),
    inversify_1.named('INSERT_TEMPLATES'),
    __metadata("design:type", Boolean)
], DevWorkspaceUpdater.prototype, "insertTemplates", void 0);
DevWorkspaceUpdater = __decorate([
    inversify_1.injectable()
], DevWorkspaceUpdater);
exports.DevWorkspaceUpdater = DevWorkspaceUpdater;
//# sourceMappingURL=devworkspace-updater.js.map