/**
 * @typedef {import('unist').Node} Node
 * @typedef {import('unist').Position} Position
 * @typedef {import('unist').Point} Point
 */
/**
 * Stringify one point, a position (start and end points), or a node’s
 * positional information.
 *
 * @param {Node|Position|Point} [value]
 * @returns {string}
 */
export function stringifyPosition(value?: Node | Position | Point): string
export type Node = import('unist').Node
export type Position = import('unist').Position
export type Point = import('unist').Point
