/**********************************************************************
 * Copyright (c) 2021 Red Hat, Inc.
 *
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 ***********************************************************************/
/**
 * Provides helper methods on top of github URL to get for example raw content of get relative links
 */
export declare class GithubUrl {
    private readonly repoUser;
    private readonly repoName;
    private readonly branchName;
    private readonly subFolder;
    static readonly RAW_LINK = "https://raw.githubusercontent.com";
    constructor(repoUser: string, repoName: string, branchName: string, subFolder: string);
    /**
     * Provides the raw link to the given path based on the current repository information
     */
    getContentUrl(path: string): string;
    getUrl(): string;
    getCloneUrl(): string;
    getRepoName(): string;
    getBranchName(): string;
}
//# sourceMappingURL=github-url.d.ts.map