/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.dom.inspections;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.util.xml.XmlDomBundle;
import com.intellij.util.xml.highlighting.DomElementAnnotationHolder;
import com.intellij.util.xml.highlighting.DomElementsInspection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.maven.dom.MavenDomBundle;
import org.jetbrains.idea.maven.dom.MavenDomUtil;
import org.jetbrains.idea.maven.dom.converters.MavenConsumerPomUtil;
import org.jetbrains.idea.maven.dom.model.MavenDomParent;
import org.jetbrains.idea.maven.dom.model.MavenDomProjectModel;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0001:\u0001\u0013B\u0005\u00a2\u0006\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u000e\u0010\u0006\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016J\u0018\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0002H\u0002J\b\u0010\u0012\u001a\u00020\rH\u0016\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/idea/maven/dom/inspections/MavenParentMissedVersionInspection;", "Lcom/intellij/util/xml/highlighting/DomElementsInspection;", "Lorg/jetbrains/idea/maven/dom/model/MavenDomProjectModel;", "()V", "checkFileElement", "", "domFileElement", "Lcom/intellij/util/xml/DomFileElement;", "holder", "Lcom/intellij/util/xml/highlighting/DomElementAnnotationHolder;", "getDefaultLevel", "Lcom/intellij/codeHighlighting/HighlightDisplayLevel;", "getGroupDisplayName", "", "getParentVersion", "currentFile", "Lcom/intellij/psi/xml/XmlFile;", "model", "getShortName", "AddVersionQuickFix", "intellij.maven"})
public final class MavenParentMissedVersionInspection
extends DomElementsInspection<MavenDomProjectModel> {
    public void checkFileElement(@NotNull DomFileElement<MavenDomProjectModel> domFileElement, @NotNull DomElementAnnotationHolder holder) {
        Intrinsics.checkNotNullParameter(domFileElement, (String)"domFileElement");
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        DomElement domElement = domFileElement.getRootElement();
        Intrinsics.checkNotNullExpressionValue((Object)domElement, (String)"domFileElement.rootElement");
        MavenDomProjectModel model2 = (MavenDomProjectModel)domElement;
        MavenDomParent mavenDomParent = model2.getMavenParent();
        Intrinsics.checkNotNullExpressionValue((Object)mavenDomParent, (String)"model.mavenParent");
        MavenDomParent parent = mavenDomParent;
        if (!parent.exists()) {
            return;
        }
        if (!parent.getVersion().exists()) {
            XmlFile xmlFile = domFileElement.getFile();
            Intrinsics.checkNotNullExpressionValue((Object)xmlFile, (String)"domFileElement.file");
            Project project = xmlFile.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"domFileElement.file.project");
            if (!MavenConsumerPomUtil.isConsumerPomResolutionApplicable(project)) {
                XmlFile xmlFile2 = domFileElement.getFile();
                Intrinsics.checkNotNullExpressionValue((Object)xmlFile2, (String)"domFileElement.file");
                String version = this.getParentVersion(xmlFile2, model2);
                CollectionsKt.listOf((Object)holder.createProblem((DomElement)parent, HighlightSeverity.ERROR, XmlDomBundle.message((String)"dom.inspections.child.tag.0.should.be.defined", (Object[])new Object[]{"version"}), new LocalQuickFix[]{new AddVersionQuickFix(version)}));
            }
        }
    }

    private final String getParentVersion(XmlFile currentFile, MavenDomProjectModel model2) {
        PsiFile psiFile;
        PsiDirectory psiDirectory = currentFile.getParent();
        if (!((psiDirectory != null && (psiDirectory = psiDirectory.getParent()) != null ? psiDirectory.findFile("pom.xml") : (psiFile = null)) instanceof XmlFile)) {
            psiFile = null;
        }
        XmlFile xmlFile = (XmlFile)psiFile;
        if (xmlFile == null) {
            return "";
        }
        XmlFile xmlFileParent = xmlFile;
        MavenDomProjectModel mavenDomProjectModel = MavenDomUtil.getMavenDomModel((PsiFile)xmlFileParent, MavenDomProjectModel.class);
        if (mavenDomProjectModel == null) {
            return "";
        }
        Intrinsics.checkNotNullExpressionValue((Object)mavenDomProjectModel, (String)"MavenDomUtil.getMavenDom\u2026:class.java) ?: return \"\"");
        MavenDomProjectModel parentModel = mavenDomProjectModel;
        MavenDomParent mavenDomParent = model2.getMavenParent();
        Intrinsics.checkNotNullExpressionValue((Object)mavenDomParent, (String)"model.mavenParent");
        MavenDomParent parentElement = mavenDomParent;
        GenericDomValue<String> genericDomValue = parentModel.getArtifactId();
        Intrinsics.checkNotNullExpressionValue(genericDomValue, (String)"parentModel.artifactId");
        String string = (String)genericDomValue.getValue();
        GenericDomValue genericDomValue2 = parentElement.getArtifactId();
        Intrinsics.checkNotNullExpressionValue((Object)genericDomValue2, (String)"parentElement.artifactId");
        if (Intrinsics.areEqual((Object)string, (Object)((String)genericDomValue2.getValue()))) {
            GenericDomValue<String> genericDomValue3 = parentModel.getGroupId();
            Intrinsics.checkNotNullExpressionValue(genericDomValue3, (String)"parentModel.groupId");
            String string2 = (String)genericDomValue3.getValue();
            GenericDomValue genericDomValue4 = parentElement.getGroupId();
            Intrinsics.checkNotNullExpressionValue((Object)genericDomValue4, (String)"parentElement.groupId");
            if (Intrinsics.areEqual((Object)string2, (Object)((String)genericDomValue4.getValue()))) {
                GenericDomValue<String> genericDomValue5 = parentModel.getVersion();
                Intrinsics.checkNotNullExpressionValue(genericDomValue5, (String)"parentModel.version");
                String string3 = (String)genericDomValue5.getValue();
                if (string3 == null) {
                    string3 = "";
                }
                return string3;
            }
        }
        return "";
    }

    @NotNull
    public String getGroupDisplayName() {
        String string = MavenDomBundle.message("inspection.group", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"MavenDomBundle.message(\"inspection.group\")");
        return string;
    }

    @NotNull
    public String getShortName() {
        return "MavenParentMissedVersionInspection";
    }

    @NotNull
    public HighlightDisplayLevel getDefaultLevel() {
        HighlightDisplayLevel highlightDisplayLevel = HighlightDisplayLevel.ERROR;
        Intrinsics.checkNotNullExpressionValue((Object)highlightDisplayLevel, (String)"HighlightDisplayLevel.ERROR");
        return highlightDisplayLevel;
    }

    public MavenParentMissedVersionInspection() {
        super(MavenDomProjectModel.class, new Class[0]);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\u0003H\u0016J\b\u0010\f\u001a\u00020\u0003H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/jetbrains/idea/maven/dom/inspections/MavenParentMissedVersionInspection$AddVersionQuickFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "myVersion", "", "(Ljava/lang/String;)V", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "getFamilyName", "getName", "intellij.maven"})
    private static final class AddVersionQuickFix
    implements LocalQuickFix {
        private final String myVersion;

        @NotNull
        public String getName() {
            String string = XmlDomBundle.message((String)"dom.quickfix.insert.required.tag.text", (Object[])new Object[]{"version"});
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"XmlDomBundle.message(\"do\u2026red.tag.text\", \"version\")");
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = XmlDomBundle.message((String)"dom.quickfix.insert.required.tag.family", (Object[])new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"XmlDomBundle.message(\"do\u2026ert.required.tag.family\")");
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
            block0: {
                XmlTag tag;
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
                XmlTag xmlTag = tag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)descriptor2.getPsiElement(), XmlTag.class, (boolean)false);
                if (xmlTag == null) break block0;
                xmlTag.add((PsiElement)tag.createChildTag("version", tag.getNamespace(), this.myVersion, false));
            }
        }

        public AddVersionQuickFix(@NotNull String myVersion) {
            Intrinsics.checkNotNullParameter((Object)myVersion, (String)"myVersion");
            this.myVersion = myVersion;
        }
    }
}

